/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.media;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class RxStreamInfo {
    private static final Set<RxStreamInfo> ACTIVE_STREAM_INFO = new HashSet<RxStreamInfo>();
    private final String sdp;
    private final String networkId;
    private final int channelId;
    private final long streamId;
    private final long sourceNodeId;

    RxStreamInfo(String sdp, String networkId, int channelId, long streamId, long sourceNodeId) {
        this.sdp = sdp;
        this.networkId = networkId;
        this.channelId = channelId;
        this.streamId = streamId;
        this.sourceNodeId = sourceNodeId;
    }

    public String getSdp() {
        return this.sdp;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public long getSourceNodeId() {
        return this.sourceNodeId;
    }

    static void activateStream(RxStreamInfo streamInfo) {
        ACTIVE_STREAM_INFO.add(streamInfo);
    }

    static void deactivateStream(RxStreamInfo streamInfo) {
        ACTIVE_STREAM_INFO.remove(streamInfo);
    }

    static boolean isDestroyed(RxStreamInfo streamInfo) {
        return !ACTIVE_STREAM_INFO.contains(streamInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RxStreamInfo)) {
            return false;
        }
        RxStreamInfo that = (RxStreamInfo)o;
        return this.channelId == that.channelId && this.streamId == that.streamId && Objects.equals(this.networkId, that.networkId);
    }

    public int hashCode() {
        return Objects.hash(this.networkId, this.channelId, this.streamId);
    }

    public String toString() {
        return "RxStreamInfo{sdp='" + this.sdp + '\'' + ", networkId='" + this.networkId + '\'' + ", channelId=" + this.channelId + ", streamId=" + this.streamId + ", sourceNodeId=" + this.sourceNodeId + '}';
    }
}

