/*
 * Decompiled with CFR 0.152.
 */
package by.stub;

import by.stub.cli.ANSITerminal;
import by.stub.cli.CommandLineInterpreter;
import by.stub.exception.Stubby4JException;
import by.stub.server.JettyManager;
import by.stub.server.JettyManagerFactory;
import java.util.Map;
import org.apache.commons.cli.ParseException;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        Main.parseCommandLineArgs(args);
        if (Main.printHelpIfRequested()) {
            return;
        }
        Main.verifyYamlDataProvided();
        Main.startStubby4jUsingCommandLineArgs();
    }

    private static void parseCommandLineArgs(String[] args) {
        try {
            CommandLineInterpreter.parseCommandLine(args);
        }
        catch (ParseException ex) {
            String msg = String.format("Could not parse provided command line arguments, error: %s", ex.toString());
            throw new Stubby4JException(msg);
        }
    }

    private static boolean printHelpIfRequested() {
        if (!CommandLineInterpreter.isHelp()) {
            return false;
        }
        CommandLineInterpreter.printHelp(Main.class);
        return true;
    }

    private static void verifyYamlDataProvided() {
        if (CommandLineInterpreter.isYamlProvided()) {
            return;
        }
        String msg = String.format("YAML data was not provided using command line option '--%s'. %sTo see all command line options run again with option '--%s'", "data", "\n", "help");
        throw new Stubby4JException(msg);
    }

    private static void startStubby4jUsingCommandLineArgs() {
        try {
            Map<String, String> commandLineArgs = CommandLineInterpreter.getCommandlineParams();
            String yamlConfigFilename = commandLineArgs.get("data");
            ANSITerminal.muteConsole(CommandLineInterpreter.isMute());
            JettyManagerFactory factory = new JettyManagerFactory();
            JettyManager jettyManager = factory.construct(yamlConfigFilename, commandLineArgs);
            jettyManager.startJetty();
        }
        catch (Exception ex) {
            String msg = String.format("Could not init stubby4j, error: %s", ex.toString());
            throw new Stubby4JException(msg, ex);
        }
    }
}

