/*
 * Decompiled with CFR 0.152.
 */
package by.stub.cli;

import by.stub.utils.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class CommandLineInterpreter {
    public static final String OPTION_ADDRESS = "location";
    public static final String OPTION_CLIENTPORT = "stubs";
    public static final String OPTION_SSLPORT = "ssl";
    public static final String OPTION_ADMINPORT = "admin";
    public static final String OPTION_CONFIG = "data";
    public static final String OPTION_KEYSTORE = "keystore";
    public static final String OPTION_KEYPASS = "password";
    public static final String OPTION_MUTE = "mute";
    public static final String OPTION_WATCH = "watch";
    public static final String OPTION_HELP = "help";
    private static final CommandLineParser POSIX_PARSER = new PosixParser();
    private static final Options OPTIONS = new Options();
    private static CommandLine line;

    private CommandLineInterpreter() {
    }

    public static void parseCommandLine(String[] args) throws ParseException {
        line = POSIX_PARSER.parse(OPTIONS, args);
    }

    public static String getCurrentJarLocation(Class theclass) {
        URL location = theclass.getProtectionDomain().getCodeSource().getLocation();
        String jarAbsolutePath = new File(location.getFile()).getAbsolutePath();
        String jar = jarAbsolutePath.replaceAll(System.getProperty("user.dir") + "/", "");
        if (StringUtils.toLower(jar).endsWith(".jar")) {
            return jar;
        }
        return "stubby4j-x.x.x-SNAPSHOT.jar";
    }

    public static boolean isMute() {
        return line.hasOption(OPTION_MUTE);
    }

    public static boolean isWatching() {
        return line.hasOption(OPTION_WATCH);
    }

    public static boolean isYamlProvided() {
        return line.hasOption(OPTION_CONFIG);
    }

    public static boolean isHelp() {
        return line.hasOption(OPTION_HELP);
    }

    public static void printHelp(Class theclass) {
        HelpFormatter formatter = new HelpFormatter();
        String command = String.format("%sjava -jar %s", "\n", CommandLineInterpreter.getCurrentJarLocation(theclass));
        formatter.printHelp(command, OPTIONS, true);
    }

    public static Map<String, String> getCommandlineParams() {
        final Option[] options = line.getOptions();
        return new HashMap<String, String>(){
            {
                for (Option option : options) {
                    this.put(option.getLongOpt(), option.getValue());
                }
            }
        };
    }

    static {
        OPTIONS.addOption("l", OPTION_ADDRESS, true, "Hostname at which to bind stubby.");
        OPTIONS.addOption("s", OPTION_CLIENTPORT, true, "Port for stub portal. Defaults to 8882.");
        OPTIONS.addOption("a", OPTION_ADMINPORT, true, "Port for admin portal. Defaults to 8889.");
        OPTIONS.addOption("t", OPTION_SSLPORT, true, "Port for SSL connection. Defaults to 7443.");
        OPTIONS.addOption("d", OPTION_CONFIG, true, "Data file to pre-load endpoints. Valid YAML 1.1 expected.");
        OPTIONS.addOption("k", OPTION_KEYSTORE, true, "Keystore file for custom SSL. By default SSL is enabled using internal keystore.");
        OPTIONS.addOption("p", OPTION_KEYPASS, true, "Password for the provided keystore file.");
        OPTIONS.addOption("h", OPTION_HELP, false, "This help text.");
        OPTIONS.addOption("m", OPTION_MUTE, false, "Prevent stubby from printing to the console.");
        OPTIONS.addOption("w", OPTION_WATCH, false, "Reload datafile when changes are made.");
    }
}

