/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.cli.CommandLineInterpreter;
import by.stub.client.StubbyHttpTransport;
import by.stub.client.StubbyRequest;
import by.stub.client.StubbyResponse;
import by.stub.client.StubbyResponseFactory;
import by.stub.server.JettyManager;
import by.stub.server.JettyManagerFactory;
import java.net.HttpURLConnection;
import java.util.HashMap;

public final class StubbyClient {
    private JettyManager jettyManager;

    public void startJetty(String yamlConfigurationFilename) throws Exception {
        this.startJetty(8882, 7443, 8889, yamlConfigurationFilename);
    }

    public void startJetty(int clientPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(clientPort, 7443, 8889, yamlConfigurationFilename);
    }

    public void startJetty(int clientPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(clientPort, 7443, adminPort, yamlConfigurationFilename);
    }

    public void startJetty(int clientPort, int sslPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        String clientPortString = String.format("%s", clientPort);
        String sslPortString = String.format("%s", sslPort);
        String adminPortString = String.format("%s", adminPort);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stubs", clientPortString);
        params.put("ssl", sslPortString);
        params.put("admin", adminPortString);
        String[] args = new String[]{"-m", "-s", clientPortString, "-a", adminPortString, "-t", sslPortString, "-d", yamlConfigurationFilename};
        CommandLineInterpreter.parseCommandLine(args);
        this.jettyManager = new JettyManagerFactory().construct(yamlConfigurationFilename, params);
        this.jettyManager.startJetty();
    }

    public void stopJetty() throws Exception {
        if (this.jettyManager != null && this.jettyManager.isJettyUp()) {
            this.jettyManager.stopJetty();
        }
    }

    public StubbyResponse doGet(String host, String uri, int stubsPort) throws Exception {
        return this.doGet(host, uri, stubsPort, null);
    }

    public StubbyResponse doGetOverSsl(String host, String uri) throws Exception {
        return this.doGetOverSsl(host, uri, 7443, null);
    }

    public StubbyResponse doGetOverSsl(String host, String uri, int port) throws Exception {
        return this.doGetOverSsl(host, uri, port, null);
    }

    public StubbyResponse doGetOverSsl(String host, String uri, int port, String encodedCredentials) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("https", "GET", uri, host, port, encodedCredentials);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doGet(String host, String uri, int stubsPort, String encodedCredentials) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("http", "GET", uri, host, stubsPort, encodedCredentials);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doGetUsingDefaults(String uri) throws Exception {
        return this.doGetUsingDefaults(uri, null);
    }

    public StubbyResponse doGetUsingDefaults(String uri, String encodedCredentials) throws Exception {
        return this.doGet("localhost", uri, 8882, encodedCredentials);
    }

    public StubbyResponse doPost(String host, String uri, int stubsPort, String post) throws Exception {
        return this.doPost(host, uri, stubsPort, null, post);
    }

    public StubbyResponse doPost(String host, String uri, int stubsPort, String encodedCredentials, String post) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("http", "POST", uri, host, stubsPort, encodedCredentials, post);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doPostUsingDefaults(String uri, String post) throws Exception {
        return this.doPostUsingDefaults(uri, post, null);
    }

    public StubbyResponse doPostUsingDefaults(String uri, String post, String encodedCredentials) throws Exception {
        return this.doPost("localhost", uri, 8882, encodedCredentials, post);
    }

    public StubbyResponse makeRequest(String scheme, String method, String host, String uri, int stubsPort, String post) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(scheme, method, uri, host, stubsPort, null, post);
        return this.makeRequest(stubbyRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StubbyResponse makeRequest(StubbyRequest stubbyRequest) throws Exception {
        StubbyHttpTransport stubbyHttpTransport = new StubbyHttpTransport(stubbyRequest);
        HttpURLConnection connection = stubbyHttpTransport.constructHttpConnection();
        try {
            connection.connect();
            StubbyResponseFactory responseFactory = new StubbyResponseFactory(connection);
            StubbyResponse stubbyResponse = responseFactory.construct();
            return stubbyResponse;
        }
        finally {
            connection.disconnect();
        }
    }
}

