/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.client.StubbyRequest;
import by.stub.exception.Stubby4JException;
import by.stub.utils.StringUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

final class StubbyHttpTransport {
    private static final Set<String> SUPPORTED_METHODS = new HashSet<String>(){
        {
            this.add("GET");
            this.add("HEAD");
            this.add("TRACE");
            this.add("OPTIONS");
            this.add("POST");
        }
    };
    private static final Set<String> POSTING_METHODS = new HashSet<String>(){
        {
            this.add("PUT");
            this.add("POST");
        }
    };
    private final StubbyRequest stubbyRequest;

    StubbyHttpTransport(StubbyRequest stubbyRequest) {
        this.stubbyRequest = stubbyRequest;
    }

    HttpURLConnection constructHttpConnection() throws IOException {
        String stubbyRequestMethod = this.stubbyRequest.getMethod();
        if (!SUPPORTED_METHODS.contains(stubbyRequestMethod)) {
            throw new Stubby4JException(String.format("HTTP method '%s' not supported when contacting stubby4j", stubbyRequestMethod));
        }
        URL url = new URL(this.stubbyRequest.constructFullUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(stubbyRequestMethod);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        this.setRequestHeaders(connection);
        if (POSTING_METHODS.contains(stubbyRequestMethod)) {
            this.writeOutputStream(connection);
        }
        return connection;
    }

    private void setRequestHeaders(HttpURLConnection connection) {
        String requestMethod;
        connection.setRequestProperty("User-Agent", StringUtils.constructUserAgentName());
        if (StringUtils.isSet(this.stubbyRequest.getBase64encodedCredentials())) {
            connection.setRequestProperty("Authorization", "Basic " + this.stubbyRequest.getBase64encodedCredentials());
        }
        if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("Content-Encoding", "UTF-8");
            int contentLength = this.stubbyRequest.calculatePostLength();
            connection.setRequestProperty("Content-Length", Integer.toString(contentLength));
            if (contentLength > 0) {
                connection.setFixedLengthStreamingMode(contentLength);
            } else {
                connection.setChunkedStreamingMode(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutputStream(HttpURLConnection connection) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
        try {
            dataOutputStream.writeBytes(this.stubbyRequest.getPost());
            dataOutputStream.flush();
        }
        finally {
            dataOutputStream.close();
        }
    }
}

