/*
 * Decompiled with CFR 0.152.
 */
package by.stub.database;

import by.stub.yaml.stubs.NotFoundStubResponse;
import by.stub.yaml.stubs.RedirectStubResponse;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import by.stub.yaml.stubs.UnauthorizedStubResponse;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataStore {
    private final File dataYaml;
    private final List<StubHttpLifecycle> stubHttpLifecycles;

    public DataStore(File dataYaml, List<StubHttpLifecycle> stubHttpLifecycles) {
        this.dataYaml = dataYaml;
        this.stubHttpLifecycles = Collections.synchronizedList(stubHttpLifecycles);
    }

    public StubResponse findStubResponseFor(StubRequest assertingRequest) {
        StubHttpLifecycle assertingLifecycle = new StubHttpLifecycle();
        assertingLifecycle.setRequest(assertingRequest);
        assertingLifecycle.setResponse(new StubResponse());
        return this.identifyStubResponseType(assertingLifecycle);
    }

    private StubResponse identifyStubResponseType(StubHttpLifecycle assertingLifecycle) {
        String givenAuthorization;
        String foundAuthorization;
        int indexOf = this.stubHttpLifecycles.indexOf(assertingLifecycle);
        if (indexOf < 0) {
            return new NotFoundStubResponse();
        }
        StubHttpLifecycle matchedLifecycle = this.stubHttpLifecycles.get(indexOf);
        Map<String, String> headers = matchedLifecycle.getRequest().getHeaders();
        if (headers.containsKey("authorization") && !(foundAuthorization = headers.get("authorization")).equals(givenAuthorization = assertingLifecycle.getRequestAuthorizationHeader())) {
            return new UnauthorizedStubResponse();
        }
        StubResponse stubResponse = matchedLifecycle.getResponse();
        if (stubResponse.hasHeader("location")) {
            RedirectStubResponse redirectStubResponse = new RedirectStubResponse();
            return redirectStubResponse.configure(stubResponse);
        }
        return stubResponse;
    }

    public void resetStubHttpLifecycles(List<StubHttpLifecycle> stubHttpLifecycles) {
        this.stubHttpLifecycles.clear();
        this.stubHttpLifecycles.addAll(stubHttpLifecycles);
    }

    public List<StubHttpLifecycle> getStubHttpLifecycles() {
        return this.stubHttpLifecycles;
    }

    public File getDataYaml() {
        return this.dataYaml;
    }
}

