/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.DataStore;
import by.stub.server.JettyContext;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import by.stub.utils.ReflectionUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class PingHandler
extends AbstractHandler {
    private static final String CSS_CLASS_HIGHLIGHTABLE = "highlightable";
    private static final String CSS_CLASS_NO_HIGHLIGHTABLE = "no-highlightable";
    private static final String NAME = "admin";
    private static final String HTML_TABLE_ROW_TEMPLATE = "<tr><td width='200px' valign='top' align='left'>%s</td><td class='%s' align='left'>%s</td></tr>";
    private static final List<String> highlightableProperties = Collections.unmodifiableList(Arrays.asList("file", "body", "post"));
    private final DataStore dataStore;
    private final JettyContext jettyContext;

    public PingHandler(JettyContext newContext, DataStore newDataStore) {
        this.jettyContext = newContext;
        this.dataStore = newDataStore;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request, NAME);
        baseRequest.setHandled(true);
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(200);
        response.setHeader("Server", HandlerUtils.constructHeaderServerName());
        try {
            response.getWriter().println(this.getConfigDataPresentation());
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }

    private String getConfigDataPresentation() throws Exception {
        List<StubHttpLifecycle> stubHttpLifecycles = this.dataStore.getStubHttpLifecycles();
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildSystemStatusHtmlTable());
        builder.append("<br /><br />");
        String htmlTemplateContent = HandlerUtils.getHtmlResourceByName("snippet_request_response_tables");
        for (StubHttpLifecycle stubHttpLifecycle : stubHttpLifecycles) {
            StubRequest stubRequest = stubHttpLifecycle.getRequest();
            builder.append(this.buildPageBodyHtml(htmlTemplateContent, "Request", ReflectionUtils.getProperties(stubRequest)));
            List<StubResponse> allResponses = stubHttpLifecycle.getAllResponses();
            for (int idx = 0; idx < allResponses.size(); ++idx) {
                String responseTableTitle = allResponses.size() == 1 ? "Response" : String.format("Response #%s", 1 + idx);
                StubResponse stubResponse = allResponses.get(idx);
                builder.append(this.buildPageBodyHtml(htmlTemplateContent, responseTableTitle, ReflectionUtils.getProperties(stubResponse)));
            }
            builder.append("<br /><br />");
        }
        return HandlerUtils.populateHtmlTemplate("ping", stubHttpLifecycles.size(), builder.toString());
    }

    private String buildSystemStatusHtmlTable() throws Exception {
        StringBuilder builder = new StringBuilder();
        String host = this.jettyContext.getHost();
        int clientPort = this.jettyContext.getStubsPort();
        int sslPort = this.jettyContext.getStubsSslPort();
        int adminPort = this.jettyContext.getAdminPort();
        builder.append(this.populateTableRowTemplate("CLIENT PORT", CSS_CLASS_NO_HIGHLIGHTABLE, clientPort));
        builder.append(this.populateTableRowTemplate("ADMIN PORT", CSS_CLASS_NO_HIGHLIGHTABLE, adminPort));
        builder.append(this.populateTableRowTemplate("SSL PORT", CSS_CLASS_NO_HIGHLIGHTABLE, sslPort));
        builder.append(this.populateTableRowTemplate("HOST", CSS_CLASS_NO_HIGHLIGHTABLE, host));
        builder.append(this.populateTableRowTemplate("CONFIGURATION", CSS_CLASS_NO_HIGHLIGHTABLE, this.dataStore.getDataYaml().getAbsolutePath()));
        String endpointRegistration = HandlerUtils.linkifyRequestUrl("http", "/stubdata/new", host, adminPort);
        builder.append(this.populateTableRowTemplate("NEW STUB DATA POST URI", CSS_CLASS_NO_HIGHLIGHTABLE, endpointRegistration));
        String systemStatusTable = HandlerUtils.getHtmlResourceByName("snippet_system_status_table");
        return String.format(systemStatusTable, builder.toString());
    }

    private String buildPageBodyHtml(String htmlTemplateContent, String tableName, Map<String, String> stubObjectProperties) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> keyValue : stubObjectProperties.entrySet()) {
            String value = keyValue.getValue();
            String key = keyValue.getKey();
            if (!StringUtils.isSet(value)) continue;
            builder.append(this.constructHtmlTableRow(key, value));
        }
        return String.format(htmlTemplateContent, tableName, builder.toString());
    }

    private String constructHtmlTableRow(String key, String value) {
        String escapedValue = StringUtils.escapeHtmlEntities(value);
        if (highlightableProperties.contains(key)) {
            String row = String.format("%s%s%s", "<pre><code>", escapedValue, "</code></pre>");
            return this.populateTableRowTemplate(StringUtils.toUpper(key), CSS_CLASS_HIGHLIGHTABLE, row);
        }
        if (key.equals("url")) {
            String linkifiedUrl = HandlerUtils.linkifyRequestUrl("http", escapedValue, this.jettyContext.getHost(), this.jettyContext.getStubsPort());
            String linkifiedSslUrl = HandlerUtils.linkifyRequestUrl("https", escapedValue, this.jettyContext.getHost(), this.jettyContext.getStubsSslPort());
            String tableRowWithUrl = this.populateTableRowTemplate(StringUtils.toUpper(key), CSS_CLASS_NO_HIGHLIGHTABLE, linkifiedUrl);
            String tableRowWithSslUrl = this.populateTableRowTemplate("SSL " + StringUtils.toUpper(key), CSS_CLASS_NO_HIGHLIGHTABLE, linkifiedSslUrl);
            return String.format("%s%s", tableRowWithUrl, tableRowWithSslUrl);
        }
        return this.populateTableRowTemplate(StringUtils.toUpper(key), CSS_CLASS_NO_HIGHLIGHTABLE, escapedValue);
    }

    private String populateTableRowTemplate(Object ... tokens) {
        return String.format(HTML_TABLE_ROW_TEMPLATE, tokens);
    }
}

