/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.DataStore;
import by.stub.handlers.strategy.HandlingStrategyFactory;
import by.stub.handlers.strategy.StubResponseHandlingStrategy;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class StubsHandler
extends AbstractHandler {
    private static final String NAME = "stubs";
    private final DataStore dataStore;

    public StubsHandler(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request, NAME);
        baseRequest.setHandled(true);
        StubRequest assertionStubRequest = StubRequest.createFromHttpServletRequest(request);
        StubResponse foundStubResponse = this.dataStore.findStubResponseFor(assertionStubRequest);
        StubResponseHandlingStrategy strategyStubResponse = HandlingStrategyFactory.identifyHandlingStrategyFor(foundStubResponse);
        try {
            strategyStubResponse.handle(response, assertionStubRequest);
            ConsoleUtils.logOutgoingResponse(request, response, NAME);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }
}

