/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.database.DataStore;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.FileUtils;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.YamlParser;
import by.stub.yaml.stubs.StubHttpLifecycle;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class StubsRegistrationHandler
extends AbstractHandler {
    private static final String NAME = "admin";
    public static final String RESOURCE_STUBDATA_NEW = "/stubdata/new";
    private final DataStore dataStore;

    public StubsRegistrationHandler(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request, NAME);
        baseRequest.setHandled(true);
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(200);
        response.setHeader("Server", HandlerUtils.constructHeaderServerName());
        if (!request.getMethod().equalsIgnoreCase("post")) {
            String errorMessage = String.format("Method %s is not allowed on URI %s", request.getMethod(), RESOURCE_STUBDATA_NEW);
            HandlerUtils.configureErrorResponse(response, 405, errorMessage);
            return;
        }
        String post = HandlerUtils.extractPostRequestBody(request, NAME);
        if (!StringUtils.isSet(post)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getPathInfo());
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        try {
            List<StubHttpLifecycle> stubHttpLifecycles = new YamlParser().parse(FileUtils.constructReader(post));
            this.dataStore.resetStubHttpLifecycles(stubHttpLifecycles);
            response.setStatus(201);
            response.getWriter().println("Configuration created successfully");
            ConsoleUtils.logOutgoingResponse(request, response, NAME);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, "Could not parse POSTed YAML configuration: " + ex.toString());
        }
    }
}

