/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy;

import by.stub.exception.Stubby4JException;
import by.stub.handlers.strategy.StubResponseHandlingStrategy;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class DefaultResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    private final StubResponse foundStubResponse;

    public DefaultResponseHandlingStrategy(StubResponse foundStubResponse) {
        this.foundStubResponse = foundStubResponse;
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws IOException {
        HandlerUtils.setResponseMainHeaders(response);
        this.setStubResponseHeaders(this.foundStubResponse, response);
        if (StringUtils.isSet(this.foundStubResponse.getLatency())) {
            try {
                long latency = Long.parseLong(this.foundStubResponse.getLatency());
                TimeUnit.MILLISECONDS.sleep(latency);
            }
            catch (InterruptedException e) {
                throw new Stubby4JException(e);
            }
        }
        response.setStatus(Integer.parseInt(this.foundStubResponse.getStatus()));
        byte[] responseBody = this.foundStubResponse.getResponseBody();
        ServletOutputStream streamOut = response.getOutputStream();
        streamOut.write(responseBody);
        streamOut.flush();
        streamOut.close();
    }

    private void setStubResponseHeaders(StubResponse stubResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        for (Map.Entry<String, String> entry : stubResponse.getHeaders().entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }
}

