/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy;

import by.stub.handlers.strategy.DefaultResponseHandlingStrategy;
import by.stub.handlers.strategy.NotFoundResponseHandlingStrategy;
import by.stub.handlers.strategy.RedirectResponseHandlingStrategy;
import by.stub.handlers.strategy.StubResponseHandlingStrategy;
import by.stub.handlers.strategy.UnauthorizedResponseHandlingStrategy;
import by.stub.yaml.stubs.StubResponse;

public final class HandlingStrategyFactory {
    private HandlingStrategyFactory() {
    }

    public static StubResponseHandlingStrategy identifyHandlingStrategyFor(StubResponse foundStubResponse) {
        switch (foundStubResponse.getStubResponseType()) {
            case NOTFOUND: {
                return new NotFoundResponseHandlingStrategy();
            }
            case UNAUTHORIZED: {
                return new UnauthorizedResponseHandlingStrategy();
            }
            case REDIRECT: {
                return new RedirectResponseHandlingStrategy(foundStubResponse);
            }
        }
        return new DefaultResponseHandlingStrategy(foundStubResponse);
    }
}

