/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy;

import by.stub.exception.Stubby4JException;
import by.stub.handlers.strategy.StubResponseHandlingStrategy;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;

public class RedirectResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    private final StubResponse foundStubResponse;

    public RedirectResponseHandlingStrategy(StubResponse foundStubResponse) {
        this.foundStubResponse = foundStubResponse;
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws IOException {
        HandlerUtils.setResponseMainHeaders(response);
        if (StringUtils.isSet(this.foundStubResponse.getLatency())) {
            try {
                long latency = Long.parseLong(this.foundStubResponse.getLatency());
                TimeUnit.MILLISECONDS.sleep(latency);
            }
            catch (InterruptedException e) {
                throw new Stubby4JException(e);
            }
        }
        response.setStatus(Integer.parseInt(this.foundStubResponse.getStatus()));
        response.setHeader("Location", this.foundStubResponse.getHeaders().get("location"));
        response.setHeader("Connection", "close");
    }
}

