/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy;

import by.stub.handlers.strategy.StubResponseHandlingStrategy;
import by.stub.repackaged.org.apache.commons.codec.binary.Base64;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public final class UnauthorizedResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws IOException {
        HandlerUtils.setResponseMainHeaders(response);
        String authorizationHeader = assertionStubRequest.getHeaders().get("authorization");
        if (authorizationHeader == null) {
            String error = "You are not authorized to view this page without supplied 'Authorization' HTTP header";
            HandlerUtils.configureErrorResponse(response, 401, error);
            return;
        }
        String expectedbase64encodedHeader = authorizationHeader.substring("Basic ".length());
        String expectedbase64decodedHeader = new String(Base64.decodeBase64(expectedbase64encodedHeader), StringUtils.charsetUTF8());
        String template = "Unauthorized with supplied encoded credentials: '%s' which decodes to '%s'";
        String error = String.format("Unauthorized with supplied encoded credentials: '%s' which decodes to '%s'", expectedbase64encodedHeader, expectedbase64decodedHeader);
        HandlerUtils.configureErrorResponse(response, 401, error);
    }
}

