/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.ANSITerminal;
import by.stub.database.DataStore;
import by.stub.exception.Stubby4JException;
import by.stub.handlers.PingHandler;
import by.stub.handlers.StubsHandler;
import by.stub.handlers.StubsRegistrationHandler;
import by.stub.server.FakeX509TrustManager;
import by.stub.server.JettyContext;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class JettyFactory {
    public static final int DEFAULT_ADMIN_PORT = 8889;
    public static final int DEFAULT_STUBS_PORT = 8882;
    public static final int DEFAULT_SSL_PORT = 7443;
    public static final String DEFAULT_HOST = "localhost";
    static final String ADMIN_CONNECTOR_NAME = "stubbyAdminConnector";
    static final String STUBS_CONNECTOR_NAME = "stubsClientConnector";
    static final String SSL_CONNECTOR_NAME = "stubsSslConnector";
    private final Map<String, String> commandLineArgs;
    private final DataStore dataStore;
    private String currentHost;
    private int currentStubsPort;
    private int currentAdminPort;
    private int currentStubsSslPort;

    public JettyFactory(Map<String, String> commandLineArgs, DataStore dataStore) {
        this.commandLineArgs = commandLineArgs;
        this.dataStore = dataStore;
    }

    public Server construct() throws IOException {
        Server server = new Server();
        server.setConnectors(this.buildConnectors());
        server.setHandler((Handler)this.constructHandlers());
        return server;
    }

    private HandlerList constructHandlers() {
        JettyContext jettyContext = new JettyContext(this.currentHost, this.currentStubsPort, this.currentStubsSslPort, this.currentAdminPort);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.constructHandler(STUBS_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/html/templates/", "default404.html")), this.constructHandler(STUBS_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/images/", "favicon.ico")), this.constructHandler(STUBS_CONNECTOR_NAME, "/", (Handler)new StubsHandler(this.dataStore)), this.constructHandler(SSL_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/html/templates/", "default404.html")), this.constructHandler(SSL_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/images/", "favicon.ico")), this.constructHandler(SSL_CONNECTOR_NAME, "/", (Handler)new StubsHandler(this.dataStore)), this.constructHandler(ADMIN_CONNECTOR_NAME, "/stubdata/new", (Handler)new StubsRegistrationHandler(this.dataStore)), this.constructHandler(ADMIN_CONNECTOR_NAME, "/ping", (Handler)new PingHandler(jettyContext, this.dataStore)), this.constructHandler(ADMIN_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/html/templates/", "admin-index.html")), this.constructHandler(ADMIN_CONNECTOR_NAME, "/highlight", (Handler)this.staticResourceHandler("ui/html/highlight/", new String[0])), this.constructHandler(ADMIN_CONNECTOR_NAME, "/", (Handler)this.staticResourceHandler("ui/images/", "favicon.ico"))});
        return handlers;
    }

    private ResourceHandler staticResourceHandler(String classPathResource, String ... staticResources) {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(staticResources);
        resourceHandler.setBaseResource(Resource.newClassPathResource((String)classPathResource));
        return resourceHandler;
    }

    private ContextHandler constructHandler(String connectorName, String pathInfo, Handler handler) {
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath(pathInfo);
        contextHandler.setAllowNullPathInfo(true);
        contextHandler.setConnectorNames(new String[]{connectorName});
        contextHandler.addLocaleEncoding(Locale.US.getDisplayName(), "UTF-8");
        contextHandler.setHandler(handler);
        return contextHandler;
    }

    private Connector[] buildConnectors() throws IOException {
        ArrayList<Object> connectors = new ArrayList<Object>();
        connectors.add(this.buildAdminConnector());
        connectors.add(this.buildStubsConnector());
        connectors.add(this.buildStubsSslConnector());
        return connectors.toArray(new Connector[connectors.size()]);
    }

    private SelectChannelConnector buildAdminConnector() {
        SelectChannelConnector adminChannel = new SelectChannelConnector();
        adminChannel.setPort(this.getAdminPort(this.commandLineArgs));
        adminChannel.setName(ADMIN_CONNECTOR_NAME);
        adminChannel.setHost(DEFAULT_HOST);
        if (this.commandLineArgs.containsKey("location")) {
            adminChannel.setHost(this.commandLineArgs.get("location"));
        }
        String status = String.format("Admin portal configured at http://%s:%s", adminChannel.getHost(), adminChannel.getPort());
        ANSITerminal.status(status);
        this.currentHost = adminChannel.getHost();
        this.currentAdminPort = adminChannel.getPort();
        return adminChannel;
    }

    private SelectChannelConnector buildStubsConnector() {
        SelectChannelConnector stubsChannel = new SelectChannelConnector();
        stubsChannel.setPort(this.getStubsPort(this.commandLineArgs));
        int idleTimeInMilliseconds = 45000;
        stubsChannel.setMaxIdleTime(45000);
        stubsChannel.setRequestHeaderSize(8192);
        stubsChannel.setName(STUBS_CONNECTOR_NAME);
        stubsChannel.setHost(DEFAULT_HOST);
        if (this.commandLineArgs.containsKey("location")) {
            stubsChannel.setHost(this.commandLineArgs.get("location"));
        }
        String status = String.format("Stubs portal configured at http://%s:%s", stubsChannel.getHost(), stubsChannel.getPort());
        ANSITerminal.status(status);
        this.currentStubsPort = stubsChannel.getPort();
        return stubsChannel;
    }

    private SslSocketConnector buildStubsSslConnector() throws IOException {
        String keystorePath = null;
        String password = "password";
        if (this.commandLineArgs.containsKey("keystore") && this.commandLineArgs.containsKey("password")) {
            password = this.commandLineArgs.get("password");
            keystorePath = this.commandLineArgs.get("keystore");
        }
        SslContextFactory sslContextFactory = this.constructSslContextFactory(password, keystorePath);
        SslSocketConnector sslConnector = new SslSocketConnector(sslContextFactory);
        sslConnector.setPort(this.getStubsSslPort(this.commandLineArgs));
        sslConnector.setName(SSL_CONNECTOR_NAME);
        sslConnector.setHost(DEFAULT_HOST);
        if (this.commandLineArgs.containsKey("location")) {
            sslConnector.setHost(this.commandLineArgs.get("location"));
        }
        String status = String.format("Stubs portal configured with SSL at https://%s:%s using %s keystore", sslConnector.getHost(), sslConnector.getPort(), keystorePath == null ? "internal" : "provided " + keystorePath);
        ANSITerminal.status(status);
        this.currentStubsSslPort = sslConnector.getPort();
        return sslConnector;
    }

    private SslContextFactory constructSslContextFactory(String password, String keystorePath) throws IOException {
        SslContextFactory sslFactory = new SslContextFactory();
        sslFactory.setKeyStorePassword(password);
        sslFactory.setKeyManagerPassword(password);
        this.relaxSslTrustManager();
        if (keystorePath == null) {
            URL keyURL = this.getClass().getResource("/ssl/localhost.jks");
            Resource keyStoreResource = Resource.newResource((URL)keyURL);
            sslFactory.setKeyStoreResource(keyStoreResource);
            return sslFactory;
        }
        sslFactory.setKeyStorePath(keystorePath);
        return sslFactory;
    }

    private void relaxSslTrustManager() {
        try {
            new FakeX509TrustManager().allowAllSSL();
        }
        catch (Exception ex) {
            throw new Stubby4JException(ex.toString(), ex);
        }
    }

    private int getStubsPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("stubs")) {
            return Integer.parseInt(commandLineArgs.get("stubs"));
        }
        return 8882;
    }

    private int getStubsSslPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("ssl")) {
            return Integer.parseInt(commandLineArgs.get("ssl"));
        }
        return 7443;
    }

    private int getAdminPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("admin")) {
            return Integer.parseInt(commandLineArgs.get("admin"));
        }
        return 8889;
    }
}

