/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.EmptyLogger;
import by.stub.database.DataStore;
import by.stub.database.thread.ConfigurationScanner;
import by.stub.server.JettyFactory;
import by.stub.server.JettyManager;
import by.stub.utils.FileUtils;
import by.stub.yaml.YamlParser;
import by.stub.yaml.stubs.StubHttpLifecycle;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JettyManagerFactory {
    public JettyManager construct(String dataYamlFilename, Map<String, String> commandLineArgs) throws Exception {
        Log.setLog((Logger)new EmptyLogger());
        File dataYamlFile = new File(dataYamlFilename);
        List<StubHttpLifecycle> httpLifecycles = new YamlParser().parse(FileUtils.constructReader(dataYamlFile));
        System.out.println();
        DataStore dataStore = new DataStore(dataYamlFile, httpLifecycles);
        JettyFactory jettyFactory = new JettyFactory(commandLineArgs, dataStore);
        Server server = jettyFactory.construct();
        if (commandLineArgs.containsKey("watch")) {
            this.watchDataStore(dataStore);
        }
        return new JettyManager(server);
    }

    public void watchDataStore(DataStore dataStore) {
        ConfigurationScanner configurationScanner = new ConfigurationScanner(dataStore);
        new Thread((Runnable)configurationScanner, ConfigurationScanner.class.getCanonicalName()).start();
    }
}

