/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.cli.ANSITerminal;
import by.stub.javax.servlet.http.HttpServletResponseWithGetStatus;
import java.util.Calendar;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;

public final class ConsoleUtils {
    private ConsoleUtils() {
    }

    public static void logIncomingRequestError(HttpServletRequest request, String source, String error) {
        String logMessage = String.format("[%s] -> %s [%s]%s: %s", ConsoleUtils.getTime(), request.getMethod(), source, request.getRequestURI(), error);
        ANSITerminal.error(logMessage);
    }

    public static void logIncomingRequest(HttpServletRequest request, String source) {
        String logMessage = String.format("[%s] -> %s [%s]%s", ConsoleUtils.getTime(), request.getMethod(), source, request.getRequestURI());
        ANSITerminal.incoming(logMessage);
    }

    public static void logOutgoingResponse(HttpServletRequest request, HttpServletResponse response, String source) {
        HttpServletResponseWithGetStatus wrapper = new HttpServletResponseWithGetStatus(response);
        int status = wrapper.getStatus();
        String logMessage = String.format("[%s] <- %s [%s]%s %s", ConsoleUtils.getTime(), status, source, request.getRequestURI(), HttpStatus.getMessage((int)status));
        if (status >= 400) {
            ANSITerminal.error(logMessage);
        } else if (status >= 300) {
            ANSITerminal.warn(logMessage);
        } else if (status >= 200) {
            ANSITerminal.ok(logMessage);
        } else if (status >= 100) {
            ANSITerminal.info(logMessage);
        } else {
            ANSITerminal.log(logMessage);
        }
    }

    private static String getTime() {
        Calendar now = Calendar.getInstance(Locale.US);
        return String.format("%02d:%02d:%02d", now.get(11), now.get(12), now.get(13));
    }
}

