/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionUtils {
    private static List<String> skipableProperties = Collections.unmodifiableList(Arrays.asList("AUTH_HEADER", "REGEX_START", "sequence", "sequenceCounter"));

    private ReflectionUtils() {
    }

    public static Map<String, String> getProperties(Object object) throws IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (final Field field : object.getClass().getDeclaredFields()) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    field.setAccessible(true);
                    return true;
                }
            });
            if (skipableProperties.contains(field.getName())) continue;
            Object fieldObject = ReflectionUtils.getPropertyValue(object, field.getName());
            String value = ReflectionUtils.determineObjectStringValue(fieldObject);
            properties.put(StringUtils.toLower(field.getName()), value);
        }
        return properties;
    }

    private static String determineObjectStringValue(Object fieldObject) throws UnsupportedEncodingException {
        if (fieldObject == null) {
            return "Not provided";
        }
        if (fieldObject instanceof byte[]) {
            byte[] objectBytes = (byte[])fieldObject;
            String toTest = new String(objectBytes);
            if (!StringUtils.isUSAscii(toTest)) {
                return "Local binary file, not able to display";
            }
            return new String(objectBytes, "UTF-8");
        }
        return fieldObject.toString();
    }

    public static void setPropertyValue(Object object, String fieldName, Object value) throws InvocationTargetException, IllegalAccessException {
        try {
            final Field field = object.getClass().getDeclaredField(fieldName);
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    field.setAccessible(true);
                    return true;
                }
            });
            field.set(object, value);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static Object getPropertyValue(Object object, String fieldName) throws InvocationTargetException, IllegalAccessException {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase("get" + fieldName)) continue;
            return method.invoke(object, new Object[0]);
        }
        return null;
    }
}

