/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.repackaged.org.apache.commons.codec.binary.Base64;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import java.util.Scanner;

public final class StringUtils {
    public static final String UTF_8 = "UTF-8";
    private static final CharsetEncoder US_ASCII_ENCODER = Charset.forName("US-ASCII").newEncoder();

    private StringUtils() {
    }

    public static boolean isUSAscii(String toTest) {
        return US_ASCII_ENCODER.canEncode(toTest);
    }

    public static boolean isSet(String toTest) {
        return toTest != null && toTest.trim().length() > 0;
    }

    public static boolean isObjectSet(Object toTest) {
        return toTest != null && toTest.toString().trim().length() > 0;
    }

    public static String toUpper(String toUpper) {
        if (!StringUtils.isSet(toUpper)) {
            return null;
        }
        return toUpper.toUpperCase(Locale.US);
    }

    public static String toLower(String toLower) {
        if (!StringUtils.isSet(toLower)) {
            return null;
        }
        return toLower.toLowerCase(Locale.US);
    }

    public static Charset charsetUTF8() {
        return Charset.forName(UTF_8);
    }

    public static String newStringUtf8(byte[] bytes) {
        return new String(bytes, StringUtils.charsetUTF8());
    }

    public static byte[] getBytesUtf8(String string) {
        return string.getBytes(StringUtils.charsetUTF8());
    }

    public static String inputStreamToString(InputStream inputStream) {
        if (inputStream == null || !StringUtils.isSet(inputStream.toString())) {
            return "Could not convert empty or null input stream to string";
        }
        return new Scanner(inputStream, UTF_8).useDelimiter("\\A").next().trim();
    }

    public static String escapeHtmlEntities(String toBeEscaped) {
        return toBeEscaped.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String trimSpacesBetweenCSVElements(String toBeFiltered) {
        return toBeFiltered.replaceAll("\",\\s+\"", "\",\"").replaceAll(",\\s+", ",");
    }

    public static String removeSquareBrackets(String toBeFiltered) {
        return toBeFiltered.replaceAll("%5B|%5D|\\[|]", "");
    }

    public static boolean isWithinSquareBrackets(String toCheck) {
        boolean isEncodedBrackets = toCheck.startsWith("%5B") && toCheck.endsWith("%5D");
        int lastCharIdx = toCheck.length() - 1;
        boolean isBrackets = toCheck.charAt(0) == '[' && toCheck.charAt(lastCharIdx) == ']';
        return isEncodedBrackets || isBrackets;
    }

    public static String decodeUrlEncodedQuotes(String toBeFiltered) {
        return toBeFiltered.replaceAll("%22", "\"").replaceAll("%27", "'");
    }

    public static String encodeSingleQuotes(String toBeEncoded) {
        return toBeEncoded.replaceAll("'", "%27");
    }

    public static String extractFilenameExtension(String filename) {
        int dotLocation = filename.lastIndexOf(".");
        return filename.substring(dotLocation);
    }

    public static String constructUserAgentName() {
        Package pkg = StringUtils.class.getPackage();
        String implementationVersion = StringUtils.isSet(pkg.getImplementationVersion()) ? pkg.getImplementationVersion() : "x.x.xx";
        return String.format("stubby4j/%s (HTTP stub client request)", implementationVersion);
    }

    public static String encodeBase64(String toEncode) {
        return Base64.encodeBase64String(StringUtils.getBytesUtf8(toEncode));
    }
}

