/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml;

import by.stub.cli.ANSITerminal;
import by.stub.utils.FileUtils;
import by.stub.utils.ReflectionUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public final class YamlParser {
    private static final Yaml SNAKE_YAML = new Yaml((BaseConstructor)new Constructor(), new Representer(), new DumperOptions(), (Resolver)new YamlParserResolver());
    private static final String YAML_NODE_REQUEST = "request";

    public List<StubHttpLifecycle> parse(Reader yamlReader) throws Exception {
        LinkedList<StubHttpLifecycle> httpLifecycles = new LinkedList<StubHttpLifecycle>();
        List<?> loadedYamlData = this.loadYamlData(yamlReader);
        for (Object rawParentNode : loadedYamlData) {
            LinkedHashMap parentNode = (LinkedHashMap)rawParentNode;
            StubHttpLifecycle parentStub = this.mapRootYamlNodeToStub(parentNode);
            httpLifecycles.add(parentStub);
            ArrayList<String> method = parentStub.getRequest().getMethod();
            String url = parentStub.getRequest().getUrl();
            String loadedMsg = String.format("Loaded: %s %s", method, url);
            ANSITerminal.loaded(loadedMsg);
        }
        return httpLifecycles;
    }

    protected StubHttpLifecycle mapRootYamlNodeToStub(LinkedHashMap<String, Object> parentNode) throws Exception {
        StubHttpLifecycle stubHttpLifecycle = new StubHttpLifecycle();
        for (Map.Entry<String, Object> parent : parentNode.entrySet()) {
            if (parent.getValue() instanceof LinkedHashMap) {
                Object targetStub = parent.getKey().equals(YAML_NODE_REQUEST) ? new StubRequest() : new StubResponse();
                Object populatedTargetStub = this.mapPairValueToRespectiveField(targetStub, (LinkedHashMap)parent.getValue());
                if (parent.getKey().equals(YAML_NODE_REQUEST)) {
                    stubHttpLifecycle.setRequest((StubRequest)populatedTargetStub);
                    continue;
                }
                stubHttpLifecycle.setResponse(populatedTargetStub);
                continue;
            }
            if (!(parent.getValue() instanceof ArrayList)) continue;
            Object populatedResponseStub = this.mapPairValueToRespectiveField((ArrayList)parent.getValue());
            stubHttpLifecycle.setResponse(populatedResponseStub);
        }
        return stubHttpLifecycle;
    }

    private Object mapPairValueToRespectiveField(ArrayList yamlProperties) throws Exception {
        LinkedList<StubResponse> responses = new LinkedList<StubResponse>();
        for (Object arrayListEntry : yamlProperties) {
            LinkedHashMap rawSequenceEntry = (LinkedHashMap)arrayListEntry;
            StubResponse sequenceResponse = new StubResponse();
            for (Map.Entry mapEntry : rawSequenceEntry.entrySet()) {
                String rawSequenceEntryKey = (String)mapEntry.getKey();
                Object rawSequenceEntryValue = mapEntry.getValue();
                ReflectionUtils.setPropertyValue(sequenceResponse, rawSequenceEntryKey, rawSequenceEntryValue);
            }
            responses.add(sequenceResponse);
        }
        return responses;
    }

    protected Object mapPairValueToRespectiveField(Object targetStub, LinkedHashMap<String, Object> yamlProperties) throws Exception {
        for (Map.Entry<String, Object> pair : yamlProperties.entrySet()) {
            final Map<String, String> rawPairValue = pair.getValue();
            String pairKey = pair.getKey();
            Object massagedPairValue = rawPairValue instanceof ArrayList ? rawPairValue : (rawPairValue instanceof Map ? this.encodeAuthorizationHeader(rawPairValue) : (pairKey.toLowerCase().equals("method") ? new ArrayList<String>(1){
                {
                    super(x0);
                    this.add(YamlParser.this.pairValueToString(rawPairValue));
                }
            } : (pairKey.toLowerCase().equals("file") ? (Object)this.extractBytesFromFilecontent(rawPairValue) : this.pairValueToString(rawPairValue))));
            ReflectionUtils.setPropertyValue(targetStub, pairKey, massagedPairValue);
        }
        return targetStub;
    }

    private byte[] extractBytesFromFilecontent(Object rawPairValue) throws IOException {
        String relativeFilePath = this.pairValueToString(rawPairValue);
        String extension = StringUtils.extractFilenameExtension(relativeFilePath);
        if (FileUtils.ASCII_TYPES.contains(extension)) {
            return FileUtils.asciiFileToUtf8Bytes(relativeFilePath);
        }
        return FileUtils.binaryFileToBytes(relativeFilePath);
    }

    private String pairValueToString(Object value) throws IOException {
        String rawValue = StringUtils.isObjectSet(value) ? value.toString() : "";
        return rawValue.trim();
    }

    protected Map<String, String> encodeAuthorizationHeader(Object value) {
        HashMap pairValue = (HashMap)value;
        if (!pairValue.containsKey("authorization")) {
            return pairValue;
        }
        String rawHeader = (String)pairValue.get("authorization");
        String authorizationHeader = StringUtils.isSet(rawHeader) ? rawHeader.trim() : rawHeader;
        String encodedAuthorizationHeader = String.format("%s %s", "Basic", StringUtils.encodeBase64(authorizationHeader));
        pairValue.put("authorization", encodedAuthorizationHeader);
        return pairValue;
    }

    protected List<?> loadYamlData(Reader io) throws IOException {
        Object loadedYaml = SNAKE_YAML.load(io);
        if (loadedYaml instanceof ArrayList) {
            return (ArrayList)loadedYaml;
        }
        throw new IOException("Loaded YAML root node must be an instance of ArrayList, otherwise something went wrong. Check provided YAML");
    }

    private static final class YamlParserResolver
    extends Resolver {
        protected void addImplicitResolvers() {
        }
    }
}

