/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml.stubs;

import by.stub.utils.CollectionUtils;
import by.stub.utils.FileUtils;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class StubRequest {
    private static final String REGEX_START = "^";
    public static final String AUTH_HEADER = "authorization";
    private String url;
    private ArrayList<String> method = new ArrayList<String>(1){
        {
            this.add("GET");
        }
    };
    private String post;
    private byte[] file;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> query = new LinkedHashMap<String, String>();

    public final ArrayList<String> getMethod() {
        ArrayList<String> uppercase = new ArrayList<String>(this.method.size());
        for (String string : this.method) {
            uppercase.add(StringUtils.toUpper(string));
        }
        return uppercase;
    }

    public void setMethod(final String newMethod) {
        this.method = new ArrayList<String>(1){
            {
                super(x0);
                this.add(StringUtils.isSet(newMethod) ? newMethod : "GET");
            }
        };
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public final String getUrl() {
        if (this.query.isEmpty()) {
            return this.url;
        }
        String queryString = CollectionUtils.constructQueryString(this.query);
        return String.format("%s?%s", this.url, queryString);
    }

    public String getPostBody() {
        if (this.file == null) {
            return FileUtils.enforceSystemLineSeparator(this.post);
        }
        String utf8FileContent = new String(this.file, StringUtils.charsetUTF8());
        return FileUtils.enforceSystemLineSeparator(utf8FileContent);
    }

    public void setPost(String post) {
        this.post = post;
    }

    public String getPost() {
        return this.post;
    }

    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        Set<Map.Entry<String, String>> entrySet = headers.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.headers.put(StringUtils.toLower(entry.getKey()), entry.getValue());
        }
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public byte[] getFile() {
        return this.file;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public static StubRequest createFromHttpServletRequest(HttpServletRequest request) throws IOException {
        StubRequest assertionRequest = new StubRequest();
        assertionRequest.setMethod(request.getMethod());
        assertionRequest.setUrl(request.getPathInfo());
        assertionRequest.setPost(HandlerUtils.extractPostRequestBody(request, "stubs"));
        Enumeration headerNamesEnumeration = request.getHeaderNames();
        AbstractList headerNames = headerNamesEnumeration == null ? new LinkedList() : Collections.list(request.getHeaderNames());
        for (String headerName : headerNames) {
            String headerValue = request.getHeader(headerName);
            assertionRequest.getHeaders().put(StringUtils.toLower(headerName), headerValue);
        }
        assertionRequest.getQuery().putAll(CollectionUtils.constructParamMap(request.getQueryString()));
        return assertionRequest;
    }

    private boolean regexMatch(String dataStoreRequestUrl, String assertingUrl) {
        Pattern pattern = Pattern.compile(dataStoreRequestUrl);
        return pattern.matcher(assertingUrl).matches();
    }

    private boolean stringsMatch(String dataStoreValue, String thisAssertingValue) {
        boolean isAssertingValueSet = StringUtils.isSet(thisAssertingValue);
        boolean isDatastoreValueSet = StringUtils.isSet(dataStoreValue);
        if (!isDatastoreValueSet) {
            return true;
        }
        if (isAssertingValueSet) {
            return dataStoreValue.equals(thisAssertingValue);
        }
        return false;
    }

    private boolean arraysIntersect(ArrayList<String> dataStoreArray, ArrayList<String> thisAssertingArray) {
        if (dataStoreArray.isEmpty()) {
            return true;
        }
        if (!thisAssertingArray.isEmpty()) {
            for (String entry : thisAssertingArray) {
                if (!dataStoreArray.contains(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean mapsMatch(Map<String, String> dataStoreMap, Map<String, String> thisAssertingMap) {
        HashMap<String, String> assertingMapCopy = new HashMap<String, String>(thisAssertingMap);
        HashMap<String, String> dataStoreMapCopy = new HashMap<String, String>(dataStoreMap);
        dataStoreMapCopy.entrySet().removeAll(assertingMapCopy.entrySet());
        return dataStoreMapCopy.isEmpty();
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
        result = 31 * result + (this.file != null ? Arrays.hashCode(this.file) : 0);
        result = 31 * result + ((Object)this.headers).hashCode();
        result = 31 * result + ((Object)this.query).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StubRequest)) {
            return false;
        }
        StubRequest dataStoreRequest = (StubRequest)o;
        if (!this.stringsMatch(dataStoreRequest.getPostBody(), this.getPostBody())) {
            return false;
        }
        if (!this.arraysIntersect(dataStoreRequest.getMethod(), this.getMethod())) {
            return false;
        }
        if (StringUtils.isSet(dataStoreRequest.url) && dataStoreRequest.url.startsWith(REGEX_START) ? !this.regexMatch(dataStoreRequest.url, this.getUrl()) : !this.stringsMatch(dataStoreRequest.url, this.url)) {
            return false;
        }
        if (!dataStoreRequest.getHeaders().isEmpty()) {
            HashMap<String, String> dataStoreHeadersCopy = new HashMap<String, String>(dataStoreRequest.getHeaders());
            dataStoreHeadersCopy.remove(AUTH_HEADER);
            if (dataStoreHeadersCopy.isEmpty()) {
                return true;
            }
            Map<String, String> assertingHeaders = this.getHeaders();
            if (assertingHeaders.isEmpty() || !this.mapsMatch(dataStoreHeadersCopy, assertingHeaders)) {
                return false;
            }
        }
        if (dataStoreRequest.getQuery().isEmpty()) {
            return true;
        }
        return !this.getQuery().isEmpty() && this.mapsMatch(dataStoreRequest.getQuery(), this.getQuery());
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StubRequest");
        sb.append("{url=").append(this.url);
        sb.append(", method=").append(this.method);
        if (this.post != null) {
            sb.append(", post=").append(this.post);
        }
        sb.append(", query=").append(this.query);
        sb.append(", headers=").append(this.headers);
        sb.append('}');
        return sb.toString();
    }
}

