/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.spring.boot.jdbi;

import ca.pjer.spring.boot.jdbi.AutoSqlObject;
import ca.pjer.spring.boot.jdbi.SqlObjectFactoryBean;
import java.util.Set;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class AutoSqlObjectRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent() && beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().hasAnnotatedMethods(SqlOperation.class.getName());
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AutoSqlObject.class));
        String basePackage = ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
        Set candidates = scanner.findCandidateComponents(basePackage);
        for (BeanDefinition candidate : candidates) {
            String candidateClassName = candidate.getBeanClassName();
            if (candidateClassName == null) continue;
            Class candidateClass = ClassUtils.resolveClassName((String)candidateClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(SqlObjectFactoryBean.class);
            beanDefinition.getPropertyValues().add("jdbi", (Object)new RuntimeBeanReference("jdbi"));
            beanDefinition.getPropertyValues().add("type", (Object)candidateClass);
            registry.registerBeanDefinition(candidateClassName, (BeanDefinition)beanDefinition);
        }
    }
}

