/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.Lazy;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

class AWSLogsStub {
    private final Comparator<InputLogEvent> inputLogEventByTimestampComparator = Comparator.comparing(InputLogEvent::getTimestamp);
    private final String logGroupName;
    private final String logStreamName;
    private final String logRegion;
    private String sequenceToken;
    private Long lastTimestamp;
    private final Lazy<AWSLogs> lazyAwsLogs = new Lazy();

    AWSLogsStub(String logGroupName, String logStreamName, String logRegion) {
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.logRegion = logRegion;
    }

    private AWSLogs awsLogs() {
        return this.lazyAwsLogs.getOrCompute(() -> {
            System.out.println("Creating AWSLogs Client");
            AWSLogsClientBuilder builder = AWSLogsClientBuilder.standard();
            builder.setRegion(this.logRegion);
            AWSLogs awsLogs = (AWSLogs)builder.build();
            this.initLogGroup(awsLogs);
            return awsLogs;
        });
    }

    private void initLogGroup(AWSLogs awsLogs) {
        try {
            awsLogs.createLogGroup(new CreateLogGroupRequest().withLogGroupName(this.logGroupName));
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
        try {
            awsLogs.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
    }

    synchronized void start() {
    }

    synchronized void stop() {
        try {
            this.awsLogs().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void logEvents(Collection<InputLogEvent> events) {
        if (events.size() > 1) {
            ArrayList<InputLogEvent> sortedEvents = new ArrayList<InputLogEvent>(events);
            Collections.sort(sortedEvents, this.inputLogEventByTimestampComparator);
            events = sortedEvents;
        }
        for (InputLogEvent event : events) {
            if (this.lastTimestamp != null && event.getTimestamp() < this.lastTimestamp) {
                event.setTimestamp(this.lastTimestamp);
                continue;
            }
            this.lastTimestamp = event.getTimestamp();
        }
        this.logPreparedEvents(events);
    }

    private void logPreparedEvents(Collection<InputLogEvent> events) {
        try {
            PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withSequenceToken(this.sequenceToken).withLogEvents(events);
            PutLogEventsResult result = this.awsLogs().putLogEvents(request);
            this.sequenceToken = result.getNextSequenceToken();
        }
        catch (DataAlreadyAcceptedException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
        }
        catch (InvalidSequenceTokenException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
            this.logPreparedEvents(events);
        }
    }
}

