/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.AWSLogsStub;
import ca.pjer.logback.AsyncWorker;
import ca.pjer.logback.SyncWorker;
import ca.pjer.logback.Worker;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AwsLogsAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private Layout<ILoggingEvent> layout;
    private String logGroupName;
    private String logStreamName;
    private String logRegion;
    private int maxBatchLogEvents = 50;
    private long maxFlushTimeMillis = 0L;
    private long maxBlockTimeMillis = 5000L;
    private AWSLogsStub awsLogsStub;
    private Worker worker;
    static final int MAX_BATCH_LOG_EVENTS = 10000;

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public String getLogRegion() {
        return this.logRegion;
    }

    public void setLogRegion(String logRegion) {
        this.logRegion = logRegion;
    }

    public int getMaxBatchLogEvents() {
        return this.maxBatchLogEvents;
    }

    public void setMaxBatchLogEvents(int maxBatchLogEvents) {
        if (maxBatchLogEvents <= 0 || maxBatchLogEvents > 10000) {
            throw new IllegalArgumentException("maxBatchLogEvents must be within 1 and 10000");
        }
        this.maxBatchLogEvents = maxBatchLogEvents;
    }

    public long getMaxFlushTimeMillis() {
        return this.maxFlushTimeMillis;
    }

    public void setMaxFlushTimeMillis(long maxFlushTimeMillis) {
        this.maxFlushTimeMillis = maxFlushTimeMillis;
    }

    public long getMaxBlockTimeMillis() {
        return this.maxBlockTimeMillis;
    }

    public void setMaxBlockTimeMillis(long maxBlockTimeMillis) {
        this.maxBlockTimeMillis = maxBlockTimeMillis;
    }

    AWSLogsStub getAwsLogsStub() {
        return this.awsLogsStub;
    }

    void setAwsLogsStub(AWSLogsStub awsLogsStub) {
        this.awsLogsStub = awsLogsStub;
    }

    void setWorker(Worker worker) {
        this.worker = worker;
    }

    public synchronized void start() {
        if (!this.isStarted()) {
            if (this.layout == null) {
                this.layout = new EchoLayout();
                this.addStatus((Status)new WarnStatus("No layout, default to " + this.layout, (Object)this));
            }
            if (this.logGroupName == null) {
                this.logGroupName = ((Object)((Object)this)).getClass().getSimpleName();
                this.addStatus((Status)new WarnStatus("No logGroupName, default to " + this.logGroupName, (Object)this));
            }
            if (this.logStreamName == null) {
                this.logStreamName = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date());
                this.addStatus((Status)new WarnStatus("No logStreamName, default to " + this.logStreamName, (Object)this));
            }
            if (this.awsLogsStub == null) {
                AWSLogsStub awsLogsStub;
                this.awsLogsStub = awsLogsStub = new AWSLogsStub(this.logGroupName, this.logStreamName, this.logRegion);
                awsLogsStub.start();
            }
            if (this.worker == null) {
                Worker worker;
                this.worker = worker = this.maxFlushTimeMillis > 0L ? new AsyncWorker(this) : new SyncWorker(this);
                worker.start();
            }
            this.layout.start();
            super.start();
        }
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            super.stop();
            this.layout.stop();
            if (this.worker != null) {
                this.worker.stop();
                this.worker = null;
            }
            if (this.awsLogsStub != null) {
                this.awsLogsStub.stop();
                this.awsLogsStub = null;
            }
        }
    }

    protected void append(ILoggingEvent event) {
        if (this.worker != null) {
            this.worker.append(event);
        }
    }
}

