/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.AwsLogsAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.amazonaws.services.logs.model.InputLogEvent;
import java.nio.charset.Charset;

abstract class Worker {
    private AwsLogsAppender awsLogsAppender;
    private static final int MAX_EVENT_SIZE = 262144;
    private static final int EVENT_SIZE_PADDING = 26;
    private static final Charset EVENT_SIZE_CHARSET = Charset.forName("UTF-8");
    private static final String ELLIPSIS = "...";

    Worker(AwsLogsAppender awsLogsAppender) {
        this.awsLogsAppender = awsLogsAppender;
    }

    AwsLogsAppender getAwsLogsAppender() {
        return this.awsLogsAppender;
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
    }

    public abstract void append(ILoggingEvent var1);

    InputLogEvent asInputLogEvent(ILoggingEvent event) {
        InputLogEvent inputLogEvent = new InputLogEvent().withTimestamp(Long.valueOf(event.getTimeStamp())).withMessage(this.awsLogsAppender.getLayout().doLayout((Object)event));
        if (Worker.eventSize(inputLogEvent) > 262144) {
            this.awsLogsAppender.addWarn(String.format("Log message exceeded Cloudwatch Log's limit of %d bytes", 262144));
            Worker.trimMessage(inputLogEvent, 262144);
        }
        return inputLogEvent;
    }

    static final int eventSize(InputLogEvent event) {
        return event.getMessage().getBytes(EVENT_SIZE_CHARSET).length + 26;
    }

    private static final void trimMessage(InputLogEvent event, int eventSize) {
        int trimmedMessageSize = eventSize - 26 - ELLIPSIS.getBytes(EVENT_SIZE_CHARSET).length;
        byte[] message = event.getMessage().getBytes(EVENT_SIZE_CHARSET);
        String unsafeTrimmed = new String(message, 0, trimmedMessageSize + 1, EVENT_SIZE_CHARSET);
        String trimmed = unsafeTrimmed.substring(0, unsafeTrimmed.length() - 1);
        event.setMessage(trimmed + ELLIPSIS);
    }
}

