/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.Collections;
import java.util.List;
import mirah.lang.ast.BlockArgument;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.OptionalArgument;
import mirah.lang.ast.OptionalArgumentList;
import mirah.lang.ast.Position;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.RequiredArgumentList;
import mirah.lang.ast.RestArgument;

public class Arguments
extends NodeImpl {
    private RequiredArgumentList required2;
    private OptionalArgumentList optional;
    private BlockArgument block;
    private RestArgument rest;
    private RequiredArgumentList required;

    public Arguments() {
    }

    public Arguments(Position position) {
        this.position_set(position);
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitArguments(this, arg);
    }

    public RequiredArgumentList required() {
        return this.required;
    }

    public void required_set(RequiredArgumentList value) {
        if (value == this.required) {
            return;
        }
        this.childRemoved(this.required);
        Node clone = this.childAdded(value);
        this.required = value = (RequiredArgumentList)clone;
    }

    public RequiredArgument required(int i) {
        RequiredArgument node = this.required.get(i);
        return node;
    }

    public int required_size() {
        if (this.required != null) {
            return this.required.size();
        }
        return 0;
    }

    public OptionalArgumentList optional() {
        return this.optional;
    }

    public void optional_set(OptionalArgumentList value) {
        if (value == this.optional) {
            return;
        }
        this.childRemoved(this.optional);
        Node clone = this.childAdded(value);
        this.optional = value = (OptionalArgumentList)clone;
    }

    public OptionalArgument optional(int i) {
        OptionalArgument node = this.optional.get(i);
        return node;
    }

    public int optional_size() {
        if (this.optional != null) {
            return this.optional.size();
        }
        return 0;
    }

    public RestArgument rest() {
        return this.rest;
    }

    public void rest_set(RestArgument value) {
        if (value == this.rest) {
            return;
        }
        this.childRemoved(this.rest);
        Node clone = this.childAdded(value);
        this.rest = value = (RestArgument)clone;
    }

    public RequiredArgumentList required2() {
        return this.required2;
    }

    public void required2_set(RequiredArgumentList value) {
        if (value == this.required2) {
            return;
        }
        this.childRemoved(this.required2);
        Node clone = this.childAdded(value);
        this.required2 = value = (RequiredArgumentList)clone;
    }

    public RequiredArgument required2(int i) {
        RequiredArgument node = this.required2.get(i);
        return node;
    }

    public int required2_size() {
        if (this.required2 != null) {
            return this.required2.size();
        }
        return 0;
    }

    public BlockArgument block() {
        return this.block;
    }

    public void block_set(BlockArgument value) {
        if (value == this.block) {
            return;
        }
        this.childRemoved(this.block);
        Node clone = this.childAdded(value);
        this.block = value = (BlockArgument)clone;
    }

    public Arguments(Position position, List required, List optional, RestArgument rest, List required2, BlockArgument block) {
        this.position_set(position);
        this.required_set(new RequiredArgumentList(position, required));
        this.optional_set(new OptionalArgumentList(position, optional));
        this.rest_set(rest);
        this.required2_set(new RequiredArgumentList(position, required2));
        this.block_set(block);
    }

    public Arguments(List required, List optional, RestArgument rest, List required2, BlockArgument block) {
        this.required_set(new RequiredArgumentList(this.position(), required));
        this.optional_set(new OptionalArgumentList(this.position(), optional));
        this.rest_set(rest);
        this.required2_set(new RequiredArgumentList(this.position(), required2));
        this.block_set(block);
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.rest() == oldChild) {
            this.rest_set((RestArgument)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.block() == oldChild) {
            this.block_set((BlockArgument)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    @Override
    public void removeChild(Node child) {
        if (this.rest() == child) {
            this.rest_set(null);
            return;
        }
        if (this.block() == child) {
            this.block_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    @Override
    public void initCopy() {
        block4: {
            super.initCopy();
            if (this.required() != null) {
                this.required = (RequiredArgumentList)this.childAdded((Node)this.required().clone());
            }
            if (this.optional() != null) {
                this.optional = (OptionalArgumentList)this.childAdded((Node)this.optional().clone());
            }
            if (this.rest() != null) {
                this.rest = (RestArgument)this.childAdded((Node)this.rest().clone());
            }
            if (this.required2() != null) {
                this.required2 = (RequiredArgumentList)this.childAdded((Node)this.required2().clone());
            }
            if (this.block() == null) break block4;
            this.block = (BlockArgument)this.childAdded((Node)this.block().clone());
        }
    }

    public static Arguments empty() {
        return Arguments.empty(null);
    }

    public static Arguments empty(Position position) {
        Arguments args = new Arguments(position, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
        return args;
    }
}

