/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.List;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import mirah.lang.ast.TypeName;

public class StaticMethodDefinition
extends MethodDefinition {
    private NodeList body;
    private Arguments arguments;
    private Identifier name;
    private AnnotationList annotations;
    private TypeName type;

    public StaticMethodDefinition() {
    }

    public StaticMethodDefinition(Position position) {
        this.position_set(position);
    }

    public StaticMethodDefinition(Position position, Identifier name, Arguments arguments, TypeName type, List body, List annotations) {
        this.position_set(position);
        this.name_set(name);
        this.arguments_set(arguments);
        this.type_set(type);
        this.body_set(new NodeList(position, body));
        this.annotations_set(new AnnotationList(position, annotations));
    }

    public StaticMethodDefinition(Identifier name, Arguments arguments, TypeName type, List body, List annotations) {
        this.name_set(name);
        this.arguments_set(arguments);
        this.type_set(type);
        this.body_set(new NodeList(this.position(), body));
        this.annotations_set(new AnnotationList(this.position(), annotations));
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.name() == oldChild) {
            this.name_set((Identifier)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.arguments() == oldChild) {
            this.arguments_set((Arguments)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.type() == oldChild) {
            this.type_set((TypeName)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    @Override
    public void removeChild(Node child) {
        if (this.name() == child) {
            this.name_set(null);
            return;
        }
        if (this.arguments() == child) {
            this.arguments_set(null);
            return;
        }
        if (this.type() == child) {
            this.type_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    @Override
    public void initCopy() {
        block4: {
            super.initCopy();
            if (this.name() != null) {
                this.name = (Identifier)this.childAdded((Node)this.name().clone());
            }
            if (this.arguments() != null) {
                this.arguments = (Arguments)this.childAdded((Node)this.arguments().clone());
            }
            if (this.type() != null) {
                this.type = (TypeName)this.childAdded((Node)this.type().clone());
            }
            if (this.body() != null) {
                this.body = (NodeList)this.childAdded((Node)this.body().clone());
            }
            if (this.annotations() == null) break block4;
            this.annotations = (AnnotationList)this.childAdded((Node)this.annotations().clone());
        }
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitStaticMethodDefinition(this, arg);
    }
}

