/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.Hash;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import org.mirah.ast.ListNodeState;
import org.mirah.ast.MetaTool;
import org.mirah.ast.NodeMeta$1;
import org.mirah.ast.NodeMeta$2;
import org.mirah.ast.NodeMeta$3;
import org.mirah.ast.NodeMeta$4;
import org.mirah.ast.NodeState;
import org.mirah.ast.TypeMapper;
import org.mirah.ast.VisitorState;
import org.mirah.macros.Compiler;

public class NodeMeta
extends MetaTool {
    private HashMap nodes = new HashMap();
    private VisitorState visitors;
    private static Map instances = Collections.synchronizedMap(new WeakHashMap());

    public NodeMeta(Compiler mirah) {
        super(mirah);
        this.visitors = new VisitorState(mirah);
    }

    public Node init_visitor(CallSite call) {
        this.visitors.init_visitor(call);
        return null;
    }

    public NodeList init_node(CallSite call) {
        NodeState node = new NodeState(this.mirah(), call, this.visitors);
        this.nodes.put(node.name(), node);
        return node.init_node(call.block());
    }

    public NodeList init_list(Identifier type) {
        ListNodeState node = new ListNodeState(this.mirah(), type, this.visitors);
        this.nodes.put(node.name(), node);
        return node.init_list(type);
    }

    public NodeList init_literal(Identifier type) {
        NodeState node = new NodeState(this.mirah(), type, this.visitors);
        this.nodes.put(node.name(), node);
        return node.init_literal(type);
    }

    public NodeList init_subclass(Identifier parent) {
        NodeState node = new NodeState(this.mirah(), parent, this.visitors);
        NodeState parent_state = (NodeState)this.nodes.get(parent.identifier());
        return node.init_subclass(parent_state);
    }

    public NodeList child(Hash hash) {
        NodeMeta$3 nodeMeta$3 = new NodeMeta$3();
        nodeMeta$3.state = (NodeState)this.nodes.get(this.enclosing_class(hash).name().identifier());
        return NodeMeta.type_map_each(new NodeList(), hash, new NodeMeta$4(nodeMeta$3));
    }

    public NodeList child_list(Hash hash) {
        NodeMeta$1 nodeMeta$1 = new NodeMeta$1();
        nodeMeta$1.state = (NodeState)this.nodes.get(this.enclosing_class(hash).name().identifier());
        return NodeMeta.type_map_each(new NodeList(), hash, new NodeMeta$2(nodeMeta$1));
    }

    public NodeList add_constructor(Identifier name) {
        NodeState state = (NodeState)this.nodes.get(this.enclosing_class(name).name().identifier());
        return state.addConstructor(name.identifier());
    }

    public static NodeMeta get(Compiler mirah) {
        Object instance;
        block0: {
            instance = instances.get(mirah);
            if (instance != null) break block0;
            instance = new NodeMeta(mirah);
            instances.put(mirah, instance);
        }
        return (NodeMeta)instance;
    }

    public static NodeList type_map_each(NodeList body, Hash hash, TypeMapper mapper) {
        int i = 0;
        int gensym0 = hash.size();
        if (i < gensym0) {
            do {
                HashEntry entry = hash.get(i);
                String name = ((Identifier)entry.key()).identifier();
                String type = ((Identifier)entry.value()).identifier();
                body.add(mapper.entry(name, type));
            } while (++i < gensym0);
        }
        return body;
    }

    public static Node init_visitor(Compiler mirah, CallSite call) {
        return NodeMeta.get(mirah).init_visitor(call);
    }

    public static Node init_node(Compiler mirah, CallSite call) {
        return NodeMeta.get(mirah).init_node(call);
    }

    public static Node init_list(Compiler mirah, Identifier type) {
        return NodeMeta.get(mirah).init_list(type);
    }

    public static Node init_literal(Compiler mirah, Identifier type) {
        return NodeMeta.get(mirah).init_literal(type);
    }

    public static NodeList init_subclass(Compiler mirah, Identifier parent) {
        return NodeMeta.get(mirah).init_subclass(parent);
    }

    public static NodeList child(Compiler mirah, Hash hash) {
        return NodeMeta.get(mirah).child(hash);
    }

    public static NodeList child_list(Compiler mirah, Hash hash) {
        return NodeMeta.get(mirah).child_list(hash);
    }

    public static NodeList add_constructor(Compiler mirah, Identifier name) {
        return NodeMeta.get(mirah).add_constructor(name);
    }
}

