/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Array;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Import;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Noop;
import mirah.lang.ast.Package;
import mirah.lang.ast.Position;
import mirah.lang.ast.SimpleNodeVisitor;
import mirah.lang.ast.TypeRefImpl;
import mirah.lang.ast.Unquote;
import org.mirah.jvm.compiler.ReportedException;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.ErrorType;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.Typer;
import org.mirah.typer.UnreachableType;
import org.mirah.util.Context;
import org.mirah.util.MirahDiagnostic;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class BaseCompiler
extends SimpleNodeVisitor {
    private static Map ACCESS;
    private Scoper scoper;
    private Context context;
    private static Map FLAGS;
    private Typer typer;

    public Context context() {
        return this.context;
    }

    public Typer typer() {
        return this.typer;
    }

    public Scoper scoper() {
        return this.scoper;
    }

    public BaseCompiler(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.scoper = this.typer.scoper();
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(16);
        hashMap.put("PUBLIC", Opcodes.ACC_PUBLIC);
        hashMap.put("PRIVATE", Opcodes.ACC_PRIVATE);
        hashMap.put("PROTECTED", Opcodes.ACC_PROTECTED);
        hashMap.put("DEFAULT", 0);
        ACCESS = hashMap;
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>(21);
        hashMap2.put("STATIC", Opcodes.ACC_STATIC);
        hashMap2.put("FINAL", Opcodes.ACC_FINAL);
        hashMap2.put("SUPER", Opcodes.ACC_SUPER);
        hashMap2.put("SYNCHRONIZED", Opcodes.ACC_SYNCHRONIZED);
        hashMap2.put("VOLATILE", Opcodes.ACC_VOLATILE);
        hashMap2.put("BRIDGE", Opcodes.ACC_BRIDGE);
        hashMap2.put("VARARGS", Opcodes.ACC_VARARGS);
        hashMap2.put("TRANSIENT", Opcodes.ACC_TRANSIENT);
        hashMap2.put("NATIVE", Opcodes.ACC_NATIVE);
        hashMap2.put("INTERFACE", Opcodes.ACC_INTERFACE);
        hashMap2.put("ABSTRACT", Opcodes.ACC_ABSTRACT);
        hashMap2.put("STRICT", Opcodes.ACC_STRICT);
        hashMap2.put("SYNTHETIC", Opcodes.ACC_SYNTHETIC);
        hashMap2.put("ANNOTATION", Opcodes.ACC_ANNOTATION);
        hashMap2.put("ENUM", Opcodes.ACC_ENUM);
        hashMap2.put("DEPRECATED", Opcodes.ACC_DEPRECATED);
        FLAGS = hashMap2;
    }

    public DiagnosticListener reportError(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.error(position, message));
        return diagnosticListener;
    }

    public DiagnosticListener reportNote(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.note(position, message));
        return diagnosticListener;
    }

    public DiagnosticListener reportWarning(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.warning(position, message));
        return diagnosticListener;
    }

    public RuntimeException reportICE(Throwable ex, Position position) {
        if (ex instanceof ReportedException) {
            throw ex;
        }
        if (ex.getCause() instanceof ReportedException) {
            throw ex.getCause();
        }
        this.reportError("Internal error: " + ex.getMessage(), position);
        throw new ReportedException(ex);
    }

    public JVMType getInferredType(Node node) {
        ResolvedType type;
        block4: {
            try {
                type = this.typer.getInferredType(node).resolve();
                if (!(type instanceof UnreachableType)) break block4;
                return null;
            }
            catch (Exception ex$1768581566) {
                throw this.reportICE(ex$1768581566, node.position());
            }
        }
        if (type instanceof ErrorType) {
            this.reportError(((ErrorType)type).message().toString(), node.position());
        }
        JVMType jVMType = (JVMType)type;
        return jVMType;
    }

    public MethodType getInferredType(MethodDefinition mdef) {
        MethodType methodType;
        try {
            methodType = (MethodType)this.typer().getInferredType(mdef).resolve();
        }
        catch (Exception ex$291846514) {
            throw this.reportICE(ex$291846514, mdef.name().position());
        }
        return methodType;
    }

    public Method methodDescriptor(String name, JVMType returnType, List argTypes) {
        int i = 0;
        Type[] args = new Type[argTypes.size()];
        int gensym0 = args.length;
        if (i < gensym0) {
            do {
                try {
                    args[i] = ((JVMType)argTypes.get(i)).getAsmType();
                }
                catch (ClassCastException classCastException) {
                    ErrorType error = (ErrorType)argTypes.get(i);
                    List e = (List)error.message().get(0);
                    IllegalArgumentException ex = new IllegalArgumentException((String)e.get(0));
                    throw this.reportICE(ex, (Position)e.get(1));
                }
            } while (++i < gensym0);
        }
        return new Method(name, returnType.getAsmType(), args);
    }

    public Method methodDescriptor(JVMMethod method) {
        Type returnType = method.returnType().getAsmType();
        String name = method.name();
        if (MemberKind.CONSTRUCTOR == method.kind()) {
            name = "<init>";
            returnType = Type.VOID_TYPE;
        } else if (MemberKind.STATIC_INITIALIZER == method.kind()) {
            name = "<clinit>";
            returnType = Type.VOID_TYPE;
        }
        List argTypes = method.argumentTypes();
        Type[] args = new Type[argTypes.size()];
        int i = 0;
        int gensym0 = args.length;
        if (i < gensym0) {
            do {
                args[i] = ((JVMType)argTypes.get(i)).getAsmType();
            } while (++i < gensym0);
        }
        return new Method(name, returnType, args);
    }

    public Scope getScope(Node node) {
        return this.scoper.getScope(node);
    }

    public Scope getIntroducedScope(Node node) {
        return this.scoper.getIntroducedScope(node);
    }

    @Override
    public Object defaultNode(Node node, Object arg) {
        return this.reportError(this.getClass().getSimpleName() + " can't compile node " + node.getClass().getSimpleName(), node.position());
    }

    public void visit(Node node, Object arg) {
        try {
            node.accept(this, arg);
        }
        catch (ReportedException ex$1396798521) {
            throw ex$1396798521;
        }
        catch (Throwable ex$390405540) {
            throw this.reportICE(ex$390405540, node.position());
        }
    }

    @Override
    public Object visitNodeList(NodeList nodes, Object expression) {
        int size = nodes.size();
        int last = size - 1;
        int i = 0;
        int gensym0 = size;
        if (i < gensym0) {
            do {
                this.visit(nodes.get(i), i < last ? null : expression);
            } while (++i < gensym0);
        }
        return null;
    }

    @Override
    public Object visitPackage(Package node, Object arg) {
        BaseCompiler baseCompiler;
        if (node.body() != null) {
            BaseCompiler baseCompiler2 = this;
            baseCompiler = baseCompiler2;
            baseCompiler2.visit(node.body(), arg);
        } else {
            baseCompiler = null;
        }
        return baseCompiler;
    }

    @Override
    public Object visitImport(Import node, Object arg) {
        Object v0 = null;
        return null;
    }

    @Override
    public Object visitNoop(Noop node, Object arg) {
        Object v0 = null;
        return null;
    }

    @Override
    public Object visitUnquote(Unquote node, Object arg) {
        for (Object n : node.nodes()) {
            this.visit((Node)n, arg);
        }
        return null;
    }

    public JVMType findType(String name) {
        return (JVMType)this.typer.type_system().get(null, new TypeRefImpl(name, false, false, null)).resolve();
    }

    @Override
    public Object visitMacroDefinition(MacroDefinition node, Object expression) {
        Object v0 = null;
        return null;
    }

    public int calculateFlagsFromAnnotations(int defaultAccess, AnnotationList annotations) {
        int access = defaultAccess;
        int flags = 0;
        int i = 0;
        int gensym0 = annotations.size();
        if (i < gensym0) {
            do {
                int gensym1;
                int j;
                Annotation anno;
                if (!"org.mirah.jvm.types.Modifiers".equals((anno = annotations.get(i)).type().typeref().name()) || (j = 0) >= (gensym1 = anno.values_size())) continue;
                do {
                    Array values;
                    int gensym2;
                    int k;
                    HashEntry entry;
                    String key;
                    if ("access".equals(key = ((Identifier)(entry = anno.values(j)).key()).identifier())) {
                        access = (Integer)ACCESS.get(((Identifier)entry.value()).identifier());
                        continue;
                    }
                    if (!"flags".equals(key) || (k = 0) >= (gensym2 = (values = (Array)entry.value()).values_size())) continue;
                    do {
                        String flag = ((Identifier)values.values(k)).identifier();
                        flags |= ((Integer)FLAGS.get(flag)).intValue();
                    } while (++k < gensym2);
                } while (++j < gensym1);
            } while (++i < gensym0);
        }
        return flags | access;
    }
}

