/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.ImplicitSelf;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Position;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.types.CallType;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class CallCompiler
extends BaseCompiler
implements MemberVisitor {
    private JVMMethod member;
    private Position position;
    private Node[] args;
    private String name;
    private Node target;
    private BaseCompiler compiler;
    private Bytecode method;
    private static Logger log = Logger.getLogger(CallCompiler.class.getName());
    private JVMType returnType;

    public CallCompiler(BaseCompiler compiler, Bytecode bytecode, Position position, Node target, String name, NodeList args, JVMType returnType) {
        super(compiler.context());
        this.compiler = compiler;
        this.method = bytecode;
        this.position = position;
        this.target = target;
        this.name = name;
        this.returnType = returnType;
        this.args = new Node[args.size()];
        int i = 0;
        int gensym0 = args.size();
        if (i < gensym0) {
            do {
                this.args[i] = args.get(i);
            } while (++i < gensym0);
        }
    }

    public CallCompiler(BaseCompiler compiler, Bytecode bytecode, Position position, Node target, String name, List args, JVMType returnType) {
        super(compiler.context());
        this.compiler = compiler;
        this.method = bytecode;
        this.position = position;
        this.target = target;
        this.name = name;
        this.returnType = returnType;
        this.args = new Node[args.size()];
        args.toArray(this.args);
    }

    public void compile(boolean expression) {
        this.getMethod().accept(this, expression);
    }

    public JVMMethod getMethod() {
        JVMMethod jVMMethod;
        if (this.member != null) {
            jVMMethod = this.member;
        } else {
            JVMMethod jVMMethod2;
            if (this.returnType instanceof CallType) {
                jVMMethod2 = ((CallType)this.returnType).member();
            } else {
                JVMType[] argTypes = new JVMType[this.args.length];
                int i = 0;
                int gensym0 = this.args.length;
                if (i < gensym0) {
                    do {
                        argTypes[i] = this.getInferredType(this.args[i]);
                    } while (++i < gensym0);
                }
                jVMMethod2 = this.getInferredType(this.target).getMethod(this.name, Arrays.asList(argTypes));
            }
            jVMMethod = this.member = jVMMethod2;
        }
        return jVMMethod;
    }

    public void recordPosition() {
        this.method.recordPosition(this.position);
    }

    public void compile(Node node) {
        this.compiler.visit(node, Boolean.TRUE);
    }

    public void convertArgs(List argumentTypes) {
        block2: {
            int i = 0;
            int num_required = this.member.isVararg() ? argumentTypes.size() - 1 : argumentTypes.size();
            int gensym0 = num_required;
            if (i < gensym0) {
                do {
                    Node arg = this.args[i];
                    this.compile(arg);
                    this.method.convertValue(this.getInferredType(arg), (JVMType)argumentTypes.get(i));
                } while (++i < gensym0);
            }
            if (!this.member.isVararg()) break block2;
            this.createVarargArray((JVMType)argumentTypes.get(i), num_required);
        }
    }

    public void createVarargArray(JVMType arrayType, int offset) {
        int vararg_items = this.args.length - offset;
        if (vararg_items == 1 ? arrayType.assignableFrom(this.getInferredType(this.args[offset])) : false) {
            this.compile(this.args[offset]);
        } else {
            JVMType type = arrayType.getComponentType();
            this.method.push(vararg_items);
            this.method.newArray(type.getAsmType());
            int i = 0;
            int gensym0 = vararg_items;
            if (i < gensym0) {
                do {
                    this.method.dup();
                    this.method.push(i);
                    Node arg = this.args[offset + i];
                    this.compile(arg);
                    this.method.convertValue(this.getInferredType(arg), type);
                    this.method.arrayStore(type.getAsmType());
                } while (++i < gensym0);
            }
        }
    }

    public void convertResult(JVMType returnedType, boolean expression) {
        if (expression) {
            this.method.convertValue(returnedType, this.returnType);
        } else {
            this.method.pop(returnedType);
        }
    }

    public int computeMathOp(String name) {
        int n;
        if ((name = name.intern()) == "+") {
            n = GeneratorAdapter.ADD;
        } else if (name == "&") {
            n = GeneratorAdapter.AND;
        } else if (name == "/") {
            n = GeneratorAdapter.DIV;
        } else if (name == "*") {
            n = GeneratorAdapter.MUL;
        } else if (name == "-@") {
            n = GeneratorAdapter.NEG;
        } else if (name == "|") {
            n = GeneratorAdapter.OR;
        } else if (name == "%") {
            n = GeneratorAdapter.REM;
        } else if (name == "<<") {
            n = GeneratorAdapter.SHL;
        } else if (name == ">>") {
            n = GeneratorAdapter.SHR;
        } else if (name == "-") {
            n = GeneratorAdapter.SUB;
        } else if (name == ">>>") {
            n = GeneratorAdapter.USHR;
        } else if (name == "^") {
            n = GeneratorAdapter.XOR;
        } else {
            throw new IllegalArgumentException("Unsupported operator " + name);
        }
        return n;
    }

    @Override
    public void visitMath(JVMMethod method, boolean expression) {
        int op = this.computeMathOp(method.name());
        JVMType type = method.returnType();
        Type asm_type = type.getAsmType();
        this.compile(this.target);
        this.method.convertValue(this.getInferredType(this.target), type);
        ArrayList<JVMType> arrayList = new ArrayList<JVMType>(1);
        arrayList.add(type);
        this.convertArgs(arrayList);
        this.recordPosition();
        this.method.math(op, asm_type);
        this.convertResult(type, expression);
    }

    public static int computeComparisonOp(String name) {
        int n;
        if ((name = name.intern()) == "==") {
            n = GeneratorAdapter.EQ;
        } else if (name == ">=") {
            n = GeneratorAdapter.GE;
        } else if (name == ">") {
            n = GeneratorAdapter.GT;
        } else if (name == "<=") {
            n = GeneratorAdapter.LE;
        } else if (name == "<") {
            n = GeneratorAdapter.LT;
        } else if (name == "!=") {
            n = GeneratorAdapter.NE;
        } else {
            throw new IllegalArgumentException("Unsupported comparison " + name);
        }
        return n;
    }

    public CallCompiler compileComparisonValues(JVMMethod method) {
        JVMType type = method.declaringClass();
        this.compile(this.target);
        this.method.convertValue(this.getInferredType(this.target), type);
        CallCompiler callCompiler = this;
        ArrayList<JVMType> arrayList = new ArrayList<JVMType>(1);
        arrayList.add(type);
        callCompiler.convertArgs(arrayList);
        return callCompiler;
    }

    @Override
    public void visitComparison(JVMMethod method, boolean expression) {
        this.compileComparisonValues(method);
        int op = CallCompiler.computeComparisonOp(method.name());
        JVMType type = method.declaringClass();
        Label ifTrue = this.method.newLabel();
        Label done = this.method.newLabel();
        this.method.ifCmp(type.getAsmType(), op, ifTrue);
        this.method.push(0);
        this.method.goTo(done);
        this.method.mark(ifTrue);
        this.method.push(1);
        this.method.mark(done);
        if (!expression) {
            this.method.pop();
        }
    }

    @Override
    public void visitMethodCall(JVMMethod method, boolean expression) {
        boolean isVoid = method.returnType().getAsmType().getDescriptor().equals("V");
        this.compile(this.target);
        JVMType returnType = method.returnType();
        if (expression ? isVoid : false) {
            this.method.dup();
            returnType = this.getInferredType(this.target);
        }
        this.convertArgs(method.argumentTypes());
        this.recordPosition();
        if (method.declaringClass().isInterface()) {
            this.method.invokeInterface(method.declaringClass().getAsmType(), this.methodDescriptor(method));
        } else {
            this.method.invokeVirtual(method.declaringClass().getAsmType(), this.methodDescriptor(method));
        }
        this.convertResult(returnType, expression);
    }

    @Override
    public void visitStaticMethodCall(JVMMethod method, boolean expression) {
        this.convertArgs(method.argumentTypes());
        this.recordPosition();
        this.method.invokeStatic(method.declaringClass().getAsmType(), this.methodDescriptor(method));
        boolean isVoid = method.returnType().getAsmType().getDescriptor().equals("V");
        if (isVoid) {
            if (expression) {
                this.method.pushNil();
            }
        } else {
            this.convertResult(method.returnType(), expression);
        }
    }

    @Override
    public void visitConstructor(JVMMethod method, boolean expression) {
        boolean isDelegateCall;
        List argTypes = method.argumentTypes();
        Type klass = method.declaringClass().getAsmType();
        int i = 0;
        Type[] asmArgs = new Type[method.argumentTypes().size()];
        int gensym0 = asmArgs.length;
        if (i < gensym0) {
            do {
                asmArgs[i] = ((JVMType)argTypes.get(i)).getAsmType();
            } while (++i < gensym0);
        }
        boolean bl = (!expression ? this.target instanceof ImplicitSelf : false) ? this.target.findAncestor(ConstructorDefinition.class) != null : (isDelegateCall = false);
        if (isDelegateCall) {
            this.method.loadThis();
        } else {
            this.method.newInstance(klass);
            if (expression) {
                this.method.dup();
            }
        }
        this.convertArgs(argTypes);
        this.recordPosition();
        Method desc = new Method("<init>", Type.getType("V"), asmArgs);
        this.method.invokeConstructor(method.declaringClass().getAsmType(), desc);
    }

    @Override
    public void visitFieldAccess(JVMMethod method, boolean expression) {
        this.compile(this.target);
        if (expression) {
            this.recordPosition();
            this.method.getField(method.declaringClass().getAsmType(), method.name(), method.returnType().getAsmType());
        } else {
            this.method.pop();
        }
    }

    @Override
    public void visitStaticFieldAccess(JVMMethod method, boolean expression) {
        block0: {
            if (!expression) break block0;
            this.recordPosition();
            this.method.getStatic(method.declaringClass().getAsmType(), method.name(), method.returnType().getAsmType());
        }
    }

    @Override
    public void visitFieldAssign(JVMMethod method, boolean expression) {
        this.compile(this.target);
        this.compile(this.args[0]);
        if (expression) {
            this.method.dupX1(this.getInferredType(this.args[0]));
        }
        this.recordPosition();
        String name = method.name();
        if (name.endsWith("=")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.endsWith("=")) {
            throw new IllegalArgumentException();
        }
        this.method.putField(method.declaringClass().getAsmType(), name, method.returnType().getAsmType());
    }

    @Override
    public void visitStaticFieldAssign(JVMMethod method, boolean expression) {
        this.compile(this.args[0]);
        if (expression) {
            this.method.dup();
        }
        this.recordPosition();
        String name = method.name();
        if (name.endsWith("=")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.endsWith("=")) {
            throw new IllegalArgumentException();
        }
        this.method.putStatic(method.declaringClass().getAsmType(), name, method.returnType().getAsmType());
    }

    @Override
    public void visitArrayAccess(JVMMethod method, boolean expression) {
        this.compile(this.target);
        this.convertArgs(method.argumentTypes());
        this.recordPosition();
        this.method.arrayLoad(method.returnType().getAsmType());
        this.convertResult(method.returnType(), expression);
    }

    @Override
    public void visitArrayAssign(JVMMethod method, boolean expression) {
        this.compile(this.target);
        JVMType value_type = this.getInferredType(this.args[1]);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(method.argumentTypes().get(0));
        arrayList.add(value_type);
        this.convertArgs(arrayList);
        if (expression) {
            this.method.dupX2(value_type);
        }
        this.method.convertValue(value_type, (JVMType)method.argumentTypes().get(1));
        this.recordPosition();
        this.method.arrayStore(method.returnType().getAsmType());
    }

    @Override
    public void visitArrayLength(JVMMethod method, boolean expression) {
        this.compile(this.target);
        this.method.arrayLength();
    }

    @Override
    public void visitClassLiteral(JVMMethod method, boolean expression) {
        block0: {
            if (!expression) break block0;
            this.recordPosition();
            this.method.push(this.getInferredType(this.target).getAsmType());
        }
    }

    @Override
    public void visitInstanceof(JVMMethod method, boolean expression) {
        this.compile(this.target);
        if (expression) {
            this.method.instanceOf(this.getInferredType(this.args[0]).getAsmType());
        } else {
            this.method.pop(this.getInferredType(this.target));
        }
    }

    @Override
    public void visitIsNull(JVMMethod method, boolean expression) {
        this.compile(this.target);
        if (expression) {
            this.recordPosition();
            Label nonNull = this.method.newLabel();
            Label done = this.method.newLabel();
            this.method.ifNonNull(nonNull);
            this.method.push(1);
            this.method.goTo(done);
            this.method.mark(nonNull);
            this.method.push(0);
            this.method.mark(done);
        } else {
            this.method.pop();
        }
    }
}

