/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Array;
import mirah.lang.ast.ClassAppendSelf;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ConstantAssign;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.FieldDeclaration;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Import;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Noop;
import mirah.lang.ast.OptionalArgument;
import mirah.lang.ast.Position;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StaticMethodDefinition;
import mirah.lang.ast.Super;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.TypeRefImpl;
import org.mirah.jvm.compiler.AnnotationCollector;
import org.mirah.jvm.compiler.ConstructorCleanup;
import org.mirah.jvm.compiler.MethodCleanup;
import org.mirah.jvm.compiler.MethodState;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.macros.Compiler;
import org.mirah.typer.MethodType;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.MirahDiagnostic;

public class ClassCleanup
extends NodeScanner {
    private ArrayList methods;
    private ClassDefinition klass;
    private static Logger log = Logger.getLogger(ClassCleanup.class.getName());
    private ArrayList constructors;
    private ArrayList init_nodes;
    private AnnotationCollector field_annotations;
    private MethodDefinition cinit;
    private Map method_states;
    private ArrayList static_init_nodes;
    private Context context;
    private boolean alreadyCleaned;
    private Typer typer;
    private Compiler parser;

    public ClassCleanup(Context context, ClassDefinition klass) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.parser = (Compiler)context.get(Compiler.class);
        this.klass = klass;
        this.static_init_nodes = new ArrayList();
        this.init_nodes = new ArrayList();
        this.constructors = new ArrayList();
        this.field_annotations = new AnnotationCollector(context);
        this.methods = new ArrayList();
        this.method_states = new HashMap(16);
    }

    public void clean() {
        if (!this.addCleanedAnnotation()) {
            return;
        }
        this.scan(this.klass.body(), null);
        if (!this.static_init_nodes.isEmpty()) {
            if (this.cinit == null) {
                this.cinit = (StaticMethodDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/class_cleanup.mirah", 62, 34, "def self.initialize:void; end", new ArrayList(0));
                this.klass.body().add(this.cinit);
                this.typer.infer(this.cinit, false);
            }
            NodeList nodes = new NodeList();
            for (Object n : this.static_init_nodes) {
                Node node = (Node)n;
                node.parent().removeChild(node);
                node.setParent(null);
                nodes.add(node);
            }
            NodeList old_body = this.cinit.body();
            this.cinit.body_set(nodes);
            this.cinit.body().add(old_body);
            this.typer.infer(nodes, false);
        }
        if (this.constructors.isEmpty() && !(this.klass instanceof InterfaceDeclaration)) {
            this.add_default_constructor();
        }
        NodeList init = this.init_nodes == null ? null : new NodeList(this.init_nodes);
        ConstructorCleanup cleanup = new ConstructorCleanup(this.context);
        for (Object n : this.constructors) {
            cleanup.clean((ConstructorDefinition)n, init);
        }
        this.declareFields();
        for (Object m : this.methods) {
            this.addOptionalMethods((MethodDefinition)m);
        }
    }

    public boolean addCleanedAnnotation() {
        int i = 0;
        int gensym0 = this.klass.annotations_size();
        if (i < gensym0) {
            do {
                Annotation anno;
                if (!"org.mirah.jvm.compiler.Cleaned".equals((anno = this.klass.annotations(i)).type().typeref().name())) continue;
                return false;
            } while (++i < gensym0);
        }
        this.klass.annotations().add(new Annotation(new SimpleString("org.mirah.jvm.compiler.Cleaned"), Collections.emptyList()));
        return true;
    }

    public boolean add_default_constructor() {
        ConstructorDefinition constructor = (ConstructorDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/class_cleanup.mirah", 112, 35, "def initialize; end", new ArrayList(0));
        constructor.body().add(new Super(constructor.position(), Collections.emptyList(), null));
        this.klass.body().add(constructor);
        this.typer.infer(constructor);
        return this.constructors.add(constructor);
    }

    public TypeRef makeTypeRef(JVMType type) {
        return new TypeRefImpl(type.name(), JVMTypeUtils.isArray(type), false, null);
    }

    public void declareFields() {
        if (this.alreadyCleaned) {
            return;
        }
        int gensym1 = 0;
        JVMType type = (JVMType)this.typer.getInferredType(this.klass).resolve();
        JVMMethod[] gensym0 = type.getDeclaredFields();
        if (gensym1 < gensym0.length) {
            do {
                JVMMethod f;
                String name;
                AnnotationList $or$1;
                AnnotationList annotations = ($or$1 = this.field_annotations.getAnnotations(name = (f = gensym0[gensym1]).name())) != null ? $or$1 : new AnnotationList();
                boolean isStatic = type.hasStaticField(f.name());
                Array flags = new Array(Collections.emptyList());
                if (isStatic) {
                    flags.values().add(new SimpleString("STATIC"));
                }
                SimpleString simpleString = new SimpleString("org.mirah.jvm.types.Modifiers");
                ArrayList<HashEntry> arrayList = new ArrayList<HashEntry>(2);
                arrayList.add(new HashEntry(new SimpleString("access"), new SimpleString("PRIVATE")));
                arrayList.add(new HashEntry(new SimpleString("flags"), flags));
                Annotation modifiers = new Annotation(simpleString, arrayList);
                annotations.add(modifiers);
                FieldDeclaration decl = new FieldDeclaration(new SimpleString(name), this.makeTypeRef(f.returnType()), Collections.emptyList());
                decl.isStatic_set(isStatic);
                decl.annotations_set(annotations);
                this.klass.body().add(decl);
                this.typer.infer(modifiers);
                this.typer.infer(decl);
            } while (++gensym1 < gensym0.length);
        }
    }

    public DiagnosticListener error(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.error(position, message));
        return diagnosticListener;
    }

    public DiagnosticListener note(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.note(position, message));
        return diagnosticListener;
    }

    public void addMethodState(MethodState state) {
        ArrayList<MethodState> methods = (ArrayList<MethodState>)this.method_states.get(state.name());
        if (methods == null) {
            ArrayList<MethodState> val0 = new ArrayList<MethodState>(0);
            this.method_states.put(state.name(), val0);
            methods = val0;
        }
        for (MethodState m : methods) {
            Diagnostic.Kind conflict = m.conflictsWith(state);
            if (conflict == null) continue;
            String desc = conflict == Diagnostic.Kind.ERROR ? "Conflicting definition of " + state : "Possibly conflicting definition of " + state;
            ((DiagnosticListener)this.context.get(DiagnosticListener.class)).report(new MirahDiagnostic(conflict, state.position(), desc));
            this.note("Previous definition of " + m, m.position());
            return;
        }
        methods.add(state);
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.error("Statement (" + node.getClass() + ") not enclosed in a method", node.position());
        return false;
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        new MethodCleanup(this.context, node).clean();
        this.methods.add(node);
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getInferredType(node).resolve()));
        return false;
    }

    @Override
    public boolean enterStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        if ("initialize".equals(node.name().identifier())) {
            this.field_annotations.collect(node.body());
            this.setCinit(node);
        }
        this.methods.add(node);
        new MethodCleanup(this.context, node).clean();
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getInferredType(node).resolve()));
        return false;
    }

    public boolean isStatic(Node node) {
        return this.typer.scoper().getScope(node).selfType().resolve().isMeta();
    }

    public void setCinit(MethodDefinition node) {
        if (this.cinit != null) {
            this.error("Duplicate static initializer", node.position());
            if (this.cinit.position() != null) {
                this.note("Previously declared here", this.cinit.position());
            }
            return;
        }
        this.cinit = node;
    }

    @Override
    public boolean enterConstructorDefinition(ConstructorDefinition node, Object arg) {
        this.constructors.add(node);
        this.field_annotations.collect(node.body());
        new MethodCleanup(this.context, node).clean();
        this.methods.add(node);
        this.addMethodState(new MethodState(node, (MethodType)this.typer.getInferredType(node).resolve()));
        return false;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        new ClassCleanup(this.context, node).clean();
        return false;
    }

    @Override
    public boolean enterInterfaceDeclaration(InterfaceDeclaration node, Object arg) {
        this.enterClassDefinition(node, arg);
        return false;
    }

    @Override
    public boolean enterImport(Import node, Object arg) {
        return false;
    }

    @Override
    public boolean enterNoop(Noop node, Object arg) {
        return false;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }

    @Override
    public boolean enterClassAppendSelf(ClassAppendSelf node, Object arg) {
        return true;
    }

    @Override
    public boolean enterConstantAssign(ConstantAssign node, Object arg) {
        this.static_init_nodes.add(node);
        return false;
    }

    @Override
    public boolean enterFieldAssign(FieldAssign node, Object arg) {
        this.field_annotations.collect(node);
        boolean $or$2 = node.isStatic();
        if ($or$2 ? $or$2 : this.isStatic(node)) {
            this.static_init_nodes.add(node);
        } else {
            this.init_nodes.add(node);
            node.parent().removeChild(node);
        }
        return false;
    }

    @Override
    public boolean enterFieldDeclaration(FieldDeclaration node, Object arg) {
        this.alreadyCleaned = true;
        return false;
    }

    @Override
    public boolean enterMacroDefinition(MacroDefinition node, Object arg) {
        this.addMethodState(new MethodState(node));
        return false;
    }

    public void addOptionalMethods(MethodDefinition mdef) {
        block2: {
            if (mdef.arguments().optional_size() <= 0) break block2;
            NodeList parent = (NodeList)mdef.parent();
            List params = this.buildDefaultParameters(mdef.arguments());
            Arguments new_args = (Arguments)mdef.arguments().clone();
            int num_optional_args = new_args.optional_size();
            int optional_arg_offset = new_args.required_size();
            log.fine("Generating " + num_optional_args + " optarg methods for " + mdef.name().identifier());
            int i = num_optional_args - 1;
            int gensym0 = 0;
            if (i >= gensym0) {
                do {
                    log.finer("Generating optarg method " + i);
                    OptionalArgument arg = new_args.optional().remove(i);
                    params.set(optional_arg_offset + i, arg.value());
                    Node method = this.buildOptargBridge(mdef, new_args, params);
                    parent.add(method);
                    this.typer.infer(method);
                } while (--i >= gensym0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List buildDefaultParameters(Arguments arguments) {
        int gensym2;
        int gensym1;
        RequiredArgument arg;
        void args;
        Object var5_2 = null;
        ArrayList<LocalAccess> params = new ArrayList<LocalAccess>();
        int i = 0;
        int gensym0 = args.required_size();
        if (i < gensym0) {
            do {
                arg = args.required(i);
                params.add(new LocalAccess(arg.position(), arg.name()));
            } while (++i < gensym0);
        }
        if ((i = 0) < (gensym1 = args.optional_size())) {
            do {
                OptionalArgument optarg = args.optional(i);
                params.add(new LocalAccess(optarg.position(), optarg.name()));
            } while (++i < gensym1);
        }
        if (args.rest() != null) {
            params.add(new LocalAccess(args.rest().position(), arg.name()));
        }
        if ((i = 0) < (gensym2 = args.required2_size())) {
            do {
                arg = args.required2(i);
                params.add(new LocalAccess(arg.position(), arg.name()));
            } while (++i < gensym2);
        }
        return params;
    }

    public Node buildOptargBridge(MethodDefinition orig, Arguments args, List params) {
        MethodDefinition mdef = (MethodDefinition)orig.clone();
        mdef.arguments_set((Arguments)args.clone());
        ArrayList<FunctionalCall> arrayList = new ArrayList<FunctionalCall>(1);
        arrayList.add(new FunctionalCall(mdef.position(), mdef.name(), params, null));
        mdef.body_set(new NodeList(arrayList));
        Position position = mdef.position();
        SimpleString simpleString = new SimpleString("org.mirah.jvm.types.Modifiers");
        ArrayList<HashEntry> arrayList2 = new ArrayList<HashEntry>(2);
        arrayList2.add(new HashEntry(new SimpleString("access"), new SimpleString("PUBLIC")));
        SimpleString simpleString2 = new SimpleString("flags");
        ArrayList<SimpleString> arrayList3 = new ArrayList<SimpleString>(2);
        arrayList3.add(new SimpleString("SYNTHETIC"));
        arrayList3.add(new SimpleString("BRIDGE"));
        arrayList2.add(new HashEntry(simpleString2, new Array(arrayList3)));
        Annotation modifiers = new Annotation(position, simpleString, arrayList2);
        MethodDefinition methodDefinition = mdef;
        ArrayList<Annotation> arrayList4 = new ArrayList<Annotation>(1);
        arrayList4.add(modifiers);
        methodDefinition.annotations_set(new AnnotationList(arrayList4));
        return methodDefinition;
    }
}

