/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Logger;
import mirah.lang.ast.Block;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Return;
import mirah.lang.ast.Script;
import mirah.lang.ast.StaticMethodDefinition;
import org.mirah.jvm.compiler.NLRStruct;
import org.mirah.jvm.compiler.NLRTransformer;
import org.mirah.jvm.compiler.RegularTransformer;
import org.mirah.jvm.compiler.StackEntry;
import org.mirah.macros.Compiler;
import org.mirah.typer.Typer;
import org.mirah.util.Context;

public class ClosureTransformer
extends NodeScanner {
    private RegularTransformer regular_transformer;
    private NLRTransformer nlr_transformer;
    private Context context;
    private Stack method_stack;
    private Compiler parser;
    private Typer typer;
    private static Logger log = Logger.getLogger(ClosureTransformer.class.getName());

    public ClosureTransformer(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.parser = (Compiler)context.get(Compiler.class);
        this.nlr_transformer = new NLRTransformer(context);
        this.regular_transformer = new RegularTransformer(context);
        this.method_stack = new Stack();
    }

    @Override
    public boolean enterMacroDefinition(MacroDefinition node, Object arg) {
        return false;
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        this.method_stack.push(new StackEntry(node));
        return true;
    }

    @Override
    public boolean enterStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        this.method_stack.push(new StackEntry(node));
        return true;
    }

    @Override
    public boolean enterScript(Script node, Object arg) {
        this.method_stack.push(new StackEntry(node));
        return true;
    }

    @Override
    public Object exitMethodDefinition(MethodDefinition node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    @Override
    public Object exitStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    @Override
    public Object exitScript(Script node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    public void exit_method(Node node, Object arg) {
        StackEntry result = (StackEntry)this.method_stack.pop();
        if (!result.had_block?()) {
            return;
        }
        if (result.has_non_local_returns?()) {
            log.finest(node + " contains non local returns");
            node.accept(this.nlr_transformer, new NLRStruct(result.node()));
        } else {
            node.accept(this.regular_transformer, new ArrayList(0));
        }
    }

    @Override
    public boolean enterBlock(Block node, Object arg) {
        this.peek_stack().enter_block!();
        return true;
    }

    @Override
    public Object exitBlock(Block node, Object arg) {
        this.peek_stack().exit_block!();
        return node;
    }

    @Override
    public boolean enterReturn(Return node, Object arg) {
        this.peek_stack().maybe_inc_non_local_returns();
        return true;
    }

    public StackEntry peek_stack() {
        return (StackEntry)this.method_stack.peek();
    }
}

