/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.logging.Logger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;

public class JvmVersion {
    private String version_string;
    private int flags;
    private static Logger log = Logger.getLogger(JvmVersion.class.getName());
    private int version;

    public JvmVersion() {
        this(System.getProperty("java.specification.version"));
    }

    public JvmVersion(String version) {
        block1: {
            this.version_string = version;
            int n = "1.4".equals(version) ? Opcodes.V1_4 : ("1.5".equals(version) ? Opcodes.V1_5 : ("1.6".equals(version) ? Opcodes.V1_6 : ("1.7".equals(version) ? Opcodes.V1_7 : (this.version = "1.8".equals(version) ? Opcodes.V1_8 : -1))));
            if (this.version < 0) {
                throw new IllegalArgumentException("Unsupported jvm version " + version);
            }
            this.flags = ClassWriter.COMPUTE_MAXS;
            if (this.version <= Opcodes.V1_5) break block1;
            this.flags |= ClassWriter.COMPUTE_FRAMES;
        }
    }

    public int bytecode_version() {
        return this.version;
    }

    public int flags() {
        return this.flags;
    }

    public int version() {
        return this.version;
    }

    public String version_string() {
        return this.version_string;
    }
}

