/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.HashMap;
import org.mirah.jvm.compiler.FlexibleAnalyzer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public class LocalInitializerAdapter
extends MethodVisitor {
    private MethodNode node;
    private MethodVisitor mv;

    public LocalInitializerAdapter(MethodVisitor mv, int flags, String desc) {
        this.node = new MethodNode(Opcodes.ASM4, flags, null, desc, null, null);
        super(Opcodes.ASM4, this.node);
        this.mv = mv;
    }

    public int instruction_count() {
        return this.node.instructions.size();
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.fixUnitializedLocals();
        this.node.accept(this.mv);
    }

    public InsnList fixUnitializedLocals() {
        InsnList insnList;
        FlexibleAnalyzer analyzer = new FlexibleAnalyzer(new BasicInterpreter());
        analyzer.analyze("Foo", this.node);
        InsnList inits = new InsnList();
        HashMap already_initialized = new HashMap(16);
        AbstractInsnNode[] array = this.node.instructions.toArray();
        Frame[] frames = analyzer.getFrames();
        int i = 0;
        int gensym0 = array.length;
        if (i < gensym0) {
            do {
                int opcode;
                boolean bl = (opcode = array[i].getOpcode()) >= Opcodes.ILOAD ? opcode <= Opcodes.ALOAD : false;
                if (!bl) continue;
                int var = ((VarInsnNode)array[i]).var;
                Frame frame = frames[i];
                if (frame == null || frame.getLocal(var) != BasicValue.UNINITIALIZED_VALUE || already_initialized.containsKey(new Integer(var))) continue;
                already_initialized.put(new Integer(var), null);
                int value = opcode == Opcodes.ILOAD ? Opcodes.ICONST_0 : (opcode == Opcodes.LLOAD ? Opcodes.LCONST_0 : (opcode == Opcodes.FLOAD ? Opcodes.FCONST_0 : (opcode == Opcodes.DLOAD ? Opcodes.DCONST_0 : Opcodes.ACONST_NULL)));
                inits.add(new InsnNode(value));
                inits.add(new VarInsnNode(opcode += Opcodes.ISTORE - Opcodes.ILOAD, var));
            } while (++i < gensym0);
        }
        if (inits.size() > 0) {
            InsnList insnList2 = this.node.instructions;
            insnList = insnList2;
            insnList2.insert(inits);
        } else {
            insnList = null;
        }
        return insnList;
    }
}

