/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.FieldDeclaration;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeRefImpl;
import org.mirah.jvm.compiler.ClassCleanup;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.Scope;
import org.mirah.typer.Typer;
import org.mirah.util.Context;

public class MethodCleanup
extends NodeScanner {
    private Scope scope;
    private Context context;
    private MethodDefinition method;
    private Typer typer;

    public MethodCleanup(Context context, MethodDefinition method) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.scope = this.typer.scoper().getIntroducedScope(method);
        this.method = method;
    }

    public void clean() {
        this.scan(this.method.body(), null);
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        return false;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        new ClassCleanup(this.context, node).clean();
        return false;
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object arg) {
        boolean bl = this.typer.getInferredType(node).resolve().equals(this.scope.binding_type()) ? node.body_size() == 0 : false;
        if (bl) {
            for (Object name : this.scope.capturedLocals()) {
                JVMType type = (JVMType)this.typer.type_system().getLocalType(this.scope, (String)name, node.position()).resolve();
                if (type instanceof MirrorType) {
                    type = (JVMType)((Object)((MirrorType)type).erasure());
                }
                TypeRefImpl typeref = new TypeRefImpl(type.name(), JVMTypeUtils.isArray(type), false, node.position());
                SimpleString simpleString = new SimpleString((String)name);
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>(1);
                SimpleString simpleString2 = new SimpleString("org.mirah.jvm.types.Modifiers");
                ArrayList<HashEntry> arrayList2 = new ArrayList<HashEntry>(1);
                arrayList2.add(new HashEntry(new SimpleString("access"), new SimpleString("PROTECTED")));
                arrayList.add(new Annotation(simpleString2, arrayList2));
                FieldDeclaration decl = new FieldDeclaration(simpleString, typeref, arrayList);
                node.body().add(decl);
                this.typer.infer(decl);
            }
        }
        this.enterClassDefinition(node, arg);
        return false;
    }

    @Override
    public boolean enterInterfaceDeclaration(InterfaceDeclaration node, Object arg) {
        this.enterClassDefinition(node, arg);
        return false;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }
}

