/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StaticMethodDefinition;
import org.mirah.jvm.compiler.ClosureTransformer;
import org.mirah.jvm.compiler.Utils;
import org.mirah.macros.MacroBuilder;
import org.mirah.typer.BlockFuture;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.util.Context;

public class RegularTransformer
extends NodeScanner {
    private Scoper scoper;
    private Context context;
    private MacroBuilder parser;
    private Typer typer;
    private static Logger log = Logger.getLogger(ClosureTransformer.class.getName());

    public RegularTransformer(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.scoper = this.typer.scoper();
        this.parser = this.typer.macro_compiler();
    }

    @Override
    public Object exitMethodDefinition(MethodDefinition node, Object list) {
        log.finest("to inject: " + list + " scope: " + this.scoper.getScope(node));
        Utils.inject_nodes(node.body(), (List)list, this.typer);
        return node;
    }

    @Override
    public Object exitStaticMethodDefinition(StaticMethodDefinition node, Object list) {
        log.finest("to inject: " + list + " scope: " + this.scoper.getScope(node));
        Utils.inject_nodes(node.body(), (List)list, this.typer);
        return node;
    }

    @Override
    public Object exitScript(Script node, Object list) {
        log.finest("to inject: " + list + " scope: " + this.scoper.getScope(node));
        Utils.inject_nodes(node.body(), (List)list, this.typer);
        return node;
    }

    @Override
    public Object exitBlock(Block node, Object arg) {
        log.finest("injecting regular closure " + node);
        this.build_and_inject_closure(node, (List)arg);
        return node;
    }

    public TypeFuture infer(Node node) {
        return this.typer.infer(node);
    }

    /*
     * WARNING - void declaration
     */
    public void build_and_inject_closure(Block block, List list) {
        void toInject;
        MethodDefinition method;
        void node;
        Object var15_3 = null;
        Node ancestor = Utils.find_enclosing_method_node((Node)node);
        NodeList enclosing_body = Utils.enclosing_body(ancestor);
        Scope method_scope = this.scoper.getScope(enclosing_body);
        Scope $ptemp$3 = method_scope;
        ResolvedType $or$4 = $ptemp$3.binding_type();
        if ($or$4 == null) {
            ClosureDefinition binding_klass = this.build_binding((Block)node);
            Utils.insert_in_front(enclosing_body, binding_klass);
            $ptemp$3.binding_type_set(this.infer(binding_klass).resolve());
        }
        BlockFuture future = (BlockFuture)this.typer.getInferredType((Node)node);
        log.finest("future " + future + " node " + node + " .parent " + node.parent());
        if (future == null) {
            return;
        }
        ClosureDefinition closure_definition = Utils.build_class(node.position(), future.resolve(), this.build_temp_name("Closure", enclosing_body));
        closure_definition.body().add(Utils.build_closure_constructor(node.position(), method_scope.binding_type()));
        if (this.contains_methods((Block)node)) {
            this.copy_methods(closure_definition, (Block)node, method_scope);
        } else {
            Arguments args;
            MethodType mtype = future.basic_block_method_type();
            Arguments arguments = args = node.arguments() != null ? (Arguments)node.arguments().clone() : new Arguments(node.position(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
            while (args.required().size() < mtype.parameterTypes().size()) {
                RequiredArgument arg = new RequiredArgument(node.position(), new SimpleString("arg" + args.required().size()), null);
                args.required().add(arg);
            }
            Constant return_type = Utils.makeTypeName(node.position(), mtype.returnType());
            method = new MethodDefinition(node.position(), new SimpleString(mtype.name()), args, return_type, null, null);
            method.body_set((NodeList)node.body().clone());
        }
        this.set_parent_scope(method, this.scoper.getScope((Node)node));
        closure_definition.body().add(method);
        toInject.add(closure_definition);
        Call new_closure = Utils.closure_call_node(node.position(), closure_definition);
        Utils.replace_block_with_closure_in_call((CallSite)node.parent(), (Block)node, new_closure);
        this.infer(new_closure);
    }

    public String build_temp_name(String middle_fix, Node block) {
        return this.scoper.getScope(block).temp(Utils.build_name_prefix(block) + "$" + middle_fix);
    }

    public Scope set_parent_scope(MethodDefinition method, Scope parent_scope) {
        Scope scope = this.scoper.addScope(method);
        scope.parent_set(parent_scope);
        return scope;
    }

    public ClosureDefinition build_binding(Block node) {
        Node md = node.findAncestor(MethodDefinition.class);
        MethodFuture mt = (MethodFuture)this.typer.infer(md);
        String klass_name = this.build_temp_name("Binding", node);
        ClosureDefinition klass = Utils.build_class(node.position(), null, klass_name);
        return klass;
    }

    public boolean contains_methods(Block block) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                return true;
            } while (++i < gensym0);
        }
        return false;
    }

    public void copy_methods(ClassDefinition klass, Block block, Scope parent_scope) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                MethodDefinition cloned = (MethodDefinition)node.clone();
                this.set_parent_scope(cloned, parent_scope);
                klass.body().add(cloned);
            } while (++i < gensym0);
        }
    }
}

