/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.ClassAppendSelf;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.Import;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Package;
import mirah.lang.ast.Script;
import mirah.lang.ast.StaticMethodDefinition;
import org.mirah.jvm.compiler.ClassCleanup;
import org.mirah.macros.Compiler;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Typer;
import org.mirah.util.AstFormatter;
import org.mirah.util.Context;

public class ScriptCleanup
extends NodeScanner {
    private ArrayList methods;
    private ClassDefinition main_class;
    private String main_type;
    private Context context;
    private ArrayList main_code;
    private Compiler parser;
    private Typer typer;
    private static Logger log = Logger.getLogger(ScriptCleanup.class.getName());

    public ScriptCleanup(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.parser = (Compiler)context.get(Compiler.class);
        this.main_code = new ArrayList();
        this.methods = new ArrayList();
    }

    @Override
    public boolean enterScript(Script node, Object arg) {
        log.log(Level.FINER, "Before cleanup:\n{0}", new AstFormatter(node));
        Scope scope = this.typer.scoper().getIntroducedScope(node);
        this.main_type = this.typer.type_system().getMainType(scope, node).resolve().name();
        return true;
    }

    @Override
    public Object exitScript(Script script, Object arg) {
        if (!(this.main_code.isEmpty() ? this.methods.isEmpty() : false)) {
            ClassDefinition klass = this.getOrCreateClass(script);
            if (!this.main_code.isEmpty()) {
                StaticMethodDefinition main = (StaticMethodDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/script_cleanup.mirah", 63, 32, "def self.main(ARGV:String[]):void; end", new ArrayList(0));
                for (Object n : this.main_code) {
                    Node node = (Node)n;
                    node.parent().removeChild(node);
                    node.setParent(null);
                    main.body().add(node);
                }
                klass.body().add(main);
                this.typer.scoper().copyScopeFrom(script, main);
                this.typer.infer(main, false);
            }
            if (!this.methods.isEmpty()) {
                ClassAppendSelf nodes = (ClassAppendSelf)this.parser.deserializeAst("src/org/mirah/jvm/compiler/script_cleanup.mirah", 75, 33, "class << self; end", new ArrayList(0));
                for (Object n : this.methods) {
                    Node mdef = (Node)n;
                    mdef.parent().removeChild(mdef);
                    mdef.setParent(null);
                    nodes.body().add(mdef);
                }
                klass.body().add(nodes);
                this.typer.infer(nodes, false);
            }
        }
        if (this.main_class != null) {
            new ClassCleanup(this.context, this.main_class).clean();
        }
        log.log(Level.FINE, "After cleanup:\n{0}", new AstFormatter(script));
        return script;
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.main_code.add(node);
        return false;
    }

    @Override
    public boolean enterMacroDefinition(MacroDefinition node, Object arg) {
        this.methods.add(node);
        return false;
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        this.methods.add(node);
        return false;
    }

    @Override
    public boolean enterStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        this.methods.add(node);
        return false;
    }

    @Override
    public boolean enterConstructorDefinition(ConstructorDefinition node, Object arg) {
        this.methods.add(node);
        return false;
    }

    @Override
    public boolean enterPackage(Package node, Object arg) {
        return false;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        ResolvedType type = this.typer.infer(node).resolve();
        if (this.main_type.equals(type.name())) {
            this.main_class = node;
        } else {
            new ClassCleanup(this.context, node).clean();
        }
        return false;
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object arg) {
        this.main_code.add(node);
        new ClassCleanup(this.context, node).clean();
        return false;
    }

    @Override
    public boolean enterInterfaceDeclaration(InterfaceDeclaration node, Object arg) {
        this.enterClassDefinition(node, arg);
        return false;
    }

    @Override
    public boolean enterImport(Import node, Object arg) {
        return false;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }

    public ClassDefinition getOrCreateClass(Script script) {
        block0: {
            if (this.main_class != null) break block0;
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.main_type);
            this.main_class = (ClassDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/script_cleanup.mirah", 146, 9, "class `@main_type`\n          def initialize;super; end\n        end", arrayList);
            this.main_class.position_set(script.position());
            script.body().insert(0, this.main_class);
            this.typer.infer(this.main_class, false);
        }
        return this.main_class;
    }
}

