/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.logging.Logger;
import mirah.lang.ast.Node;
import mirah.lang.ast.StringConcat;
import mirah.lang.ast.StringEval;
import mirah.lang.ast.StringPieceList;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.compiler.MethodCompiler;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class StringCompiler
extends BaseCompiler {
    private Bytecode bytecode;
    private JVMType sb = this.findType("java.lang.StringBuilder");
    private MethodCompiler method;
    private static Logger log = Logger.getLogger(StringCompiler.class.getName());

    public StringCompiler(MethodCompiler method) {
        super(method.context());
        this.method = method;
        this.bytecode = method.bytecode();
    }

    @Override
    public Object defaultNode(Node node, Object expression) {
        this.method.compile(node);
        JVMType type = this.getInferredType(node);
        ArrayList<JVMType> arrayList = new ArrayList<JVMType>(1);
        arrayList.add(type);
        JVMMethod method = this.sb.getMethod("append", arrayList);
        Bytecode bytecode = this.bytecode;
        bytecode.invokeVirtual(this.sb.getAsmType(), this.methodDescriptor(method));
        return bytecode;
    }

    public void compile(StringPieceList node, boolean expression) {
        Type sb = this.sb.getAsmType();
        this.bytecode.newInstance(sb);
        this.bytecode.dup();
        this.bytecode.invokeConstructor(sb, new Method("<init>", Type.getType("V"), new Type[0]));
        this.visitStringPieceList(node, Boolean.TRUE);
        this.bytecode.invokeVirtual(sb, this.methodDescriptor("toString", this.findType("java.lang.String"), new ArrayList(0)));
        if (!expression) {
            this.bytecode.pop();
        }
    }

    @Override
    public Object visitStringConcat(StringConcat node, Object expression) {
        return this.visitStringPieceList(node.strings(), expression);
    }

    @Override
    public Object visitStringPieceList(StringPieceList node, Object expression) {
        int i = 0;
        int gensym0 = node.size();
        if (i < gensym0) {
            do {
                node.get(i).accept(this, expression);
            } while (++i < gensym0);
        }
        return null;
    }

    @Override
    public Object visitStringEval(StringEval node, Object expression) {
        return node.value().accept(this, expression);
    }
}

