/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.mirah.jvm.mirrors.AsyncMember$1;
import org.mirah.jvm.mirrors.AsyncMember$2;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.TypeFuture;

public class AsyncMember
extends Member {
    private List futures;
    private static Logger log = Logger.getLogger(AsyncMember.class.getName());
    private TypeFuture returnType;
    private ArrayList resolvedArguments;

    public AsyncMember(int flags, MirrorType klass, String name, List argumentTypes, TypeFuture returnType, MemberKind kind) {
        super(flags, klass, name, Collections.emptyList(), null, kind);
        this.futures = argumentTypes;
        this.resolvedArguments = new ArrayList(argumentTypes.size());
        this.returnType = returnType;
        for (Object a : argumentTypes) {
            this.setupArgumentListener((TypeFuture)a);
        }
    }

    @Override
    public List argumentTypes() {
        return Collections.unmodifiableList(this.resolvedArguments);
    }

    @Override
    public JVMType returnType() {
        return (JVMType)this.returnType.resolve();
    }

    @Override
    public TypeFuture asyncArgument(int index) {
        return (TypeFuture)this.futures.get(index);
    }

    @Override
    public TypeFuture asyncReturnType() {
        return this.returnType;
    }

    public void setupArgumentListener(TypeFuture argument) {
        AsyncMember$1 asyncMember$1 = new AsyncMember$1();
        asyncMember$1.resolvedArgs = this.resolvedArguments;
        asyncMember$1.index = this.resolvedArguments.size();
        asyncMember$1.member = this;
        asyncMember$1.log = log;
        this.resolvedArguments.add(argument.resolve());
        argument.onUpdate(new AsyncMember$2(asyncMember$1));
    }

    public void invalidate() {
        ((MirrorType)this.declaringClass()).invalidateMethod(this.name());
    }
}

