/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.mirah.jvm.mirrors.ArrayType;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.BytecodeMirror;
import org.mirah.jvm.mirrors.MacroMember;
import org.mirah.jvm.mirrors.MirrorLoader;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.OrErrorLoader;
import org.mirah.jvm.mirrors.ResourceLoader;
import org.mirah.jvm.mirrors.SimpleMirrorLoader;
import org.mirah.util.Context;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class BytecodeMirrorLoader
extends SimpleMirrorLoader {
    private OrErrorLoader ancestorLoader;
    private ResourceLoader loader;
    private Context context;
    private static Logger log = Logger.getLogger(BytecodeMirrorLoader.class.getName());

    public BytecodeMirrorLoader(Context context, ResourceLoader resourceLoader, MirrorLoader parent) {
        super(parent);
        this.context = context;
        this.loader = resourceLoader;
        this.ancestorLoader = new OrErrorLoader(this);
    }

    @Override
    public MirrorType findMirror(Type type) {
        MirrorType mirrorType;
        MirrorType $or$10 = super.findMirror(type);
        if ($or$10 != null) {
            mirrorType = $or$10;
        } else {
            if (type.getSort() == Type.ARRAY) {
                return this.findArrayMirror(Type.getType(type.getDescriptor().substring(1)));
            }
            String classfile = type.getInternalName() + ".class";
            while (true) {
                int lastSlash;
                InputStream bytecode = this.loader.getResourceAsStream(classfile);
                if (bytecode != null) {
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(bytecode);
                    reader.accept(node, ClassReader.SKIP_CODE);
                    if ((node.name + ".class").equals(classfile)) {
                        log.fine("Found " + classfile);
                        BytecodeMirror mirror = new BytecodeMirror(this.context, node, this.ancestorLoader);
                        for (Object name : BytecodeMirrorLoader.findMacros(node)) {
                            BytecodeMirrorLoader.addMacro(mirror, (String)name);
                        }
                        return mirror;
                    }
                }
                if ((lastSlash = classfile.lastIndexOf(47)) == -1) break;
                classfile = classfile.substring(0, lastSlash) + "$" + classfile.substring(lastSlash + 1);
            }
            log.finer("Cannot find " + classfile);
            mirrorType = null;
        }
        return mirrorType;
    }

    public MirrorType findArrayMirror(Type type) {
        MirrorType component = this.loadMirror(type);
        return component != null ? new ArrayType(this.context, component) : null;
    }

    public static Logger addMacro(BaseType type, String name) {
        ClassLoader classloader = (ClassLoader)type.context().get(ClassLoader.class);
        Class<?> klass = classloader != null ? classloader.loadClass(name) : Class.forName(name);
        MacroMember member = MacroMember.create(klass, type, type.context());
        type.add(member);
        Logger logger = log;
        logger.fine("Loaded macro " + member);
        return logger;
    }

    public static Object extendClass(BaseType type, Class extensions) {
        String path = "/" + extensions.getName().replace('.', '/') + ".class";
        InputStream stream = extensions.getResourceAsStream(path);
        ClassNode node = new ClassNode();
        new ClassReader(stream).accept(node, ClassReader.SKIP_CODE);
        List macros = BytecodeMirrorLoader.findMacros(node);
        for (Object name : macros) {
            BytecodeMirrorLoader.addMacro(type, (String)name);
        }
        return null;
    }

    public static List findMacros(ClassNode klass) {
        if (klass.invisibleAnnotations != null) {
            for (Object a : klass.invisibleAnnotations) {
                AnnotationNode annotation = (AnnotationNode)a;
                if (!"Lorg/mirah/macros/anno/Extensions;".equals(annotation.desc)) continue;
                return (List)annotation.values.get(1);
            }
        }
        return Collections.emptyList();
    }

    public BytecodeMirrorLoader(Context context, ResourceLoader resourceLoader) {
        this(context, resourceLoader, null);
    }
}

