/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mirah.lang.ast.Node;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.JVMScope$1;
import org.mirah.jvm.mirrors.JVMScope$2;
import org.mirah.typer.LocalFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.simple.SimpleScope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JVMScope
extends SimpleScope {
    private Map local_types;
    private HashSet shadowed;
    private HashSet defined_locals = new HashSet();
    private HashSet children;
    private JVMScope parent;
    private List cached_packages;
    private Map imports;
    private Scoper scoper;
    private Map cached_imports;
    private TypeFuture selfType;
    private List search_packages;
    private HashSet staticImports;
    private Set cached_static_imports;
    private ResolvedType binding_type;

    public JVMScope(Scoper scoper) {
        this.local_types = new HashMap(16);
        this.scoper = scoper;
        this.search_packages = new ArrayList(0);
        this.imports = new HashMap(16);
        this.staticImports = new HashSet();
        this.children = new HashSet();
        this.shadowed = new HashSet();
    }

    @Override
    public ResolvedType binding_type() {
        return this.parent() != null ? this.parent().binding_type() : this.binding_type;
    }

    @Override
    public void binding_type_set(ResolvedType type) {
        if (this.parent() != null) {
            this.parent().binding_type_set(type);
        } else {
            this.binding_type = type;
        }
    }

    public LocalFuture getLocalType(String name, Position position) {
        LocalFuture type;
        block1: {
            new JVMScope$1().name = name;
            JVMScope$1 jVMScope$1 = new JVMScope$1();
            type = (LocalFuture)this.local_types.get(jVMScope$1.name);
            if (type != null) break block1;
            type = new LocalFuture(jVMScope$1.name, position);
            jVMScope$1.locals = this.defined_locals;
            type.onUpdate(new JVMScope$2(jVMScope$1));
            boolean bl = this.parent != null ? !this.shadowed?(jVMScope$1.name) : false;
            if (bl) {
                type.parent_set(this.parent.getLocalType(jVMScope$1.name, position));
            }
            this.local_types.put(jVMScope$1.name, type);
        }
        return type;
    }

    @Override
    public boolean hasLocal(String name, boolean includeParent) {
        boolean $or$1 = this.defined_locals.contains(name);
        return $or$1 ? $or$1 : ((includeParent ? this.parent : null) != null ? this.parent.hasLocal(name) : false);
    }

    @Override
    public boolean shadowed?(String name) {
        return this.shadowed.contains(name);
    }

    @Override
    public boolean isCaptured(String name) {
        if (!this.defined_locals.contains(name)) {
            return false;
        }
        if (this.parent != null ? this.parent.hasLocal(name) : false) {
            return true;
        }
        boolean gensym0 = false;
        for (Object child : this.children) {
            if (!((JVMScope)child).hasLocal(name, false)) continue;
            gensym0 = true;
            break;
        }
        return gensym0;
    }

    @Override
    public List capturedLocals() {
        ArrayList captured = new ArrayList(this.defined_locals.size());
        for (Object name : this.defined_locals) {
            if (!this.isCaptured((String)name)) continue;
            captured.add(name);
        }
        return captured;
    }

    public boolean addChild(JVMScope scope) {
        return this.children.add(scope);
    }

    public boolean removeChild(JVMScope scope) {
        return this.children.remove(scope);
    }

    @Override
    public Scope parent() {
        return this.parent;
    }

    @Override
    public void parent_set(Scope parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        ((JVMScope)parent).addChild(this);
        this.parent = (JVMScope)parent;
        this.flush();
    }

    public JVMScope outer_scope() {
        boolean $or$3;
        boolean $or$2;
        Node node = this.context();
        boolean bl = $or$2 = this.scoper == null;
        boolean bl2 = $or$2 ? $or$2 : ($or$3 = node == null);
        if ($or$3 ? $or$3 : node.parent() == null) {
            return null;
        }
        return (JVMScope)this.scoper.getScope(node);
    }

    @Override
    public String package() {
        JVMScope outer = this.outer_scope();
        String $or$4 = super.package();
        return $or$4 != null ? $or$4 : (outer != null ? outer.package() : null);
    }

    public Map fetch_imports(Map map) {
        JVMScope parent_scope = this.outer_scope();
        if (parent_scope != null) {
            parent_scope.fetch_imports(map);
        }
        Map map2 = map;
        map2.putAll(this.imports);
        return map2;
    }

    public List fetch_packages(List list) {
        JVMScope parent_scope = this.outer_scope();
        if (parent_scope != null) {
            parent_scope.fetch_packages(list);
        }
        list.addAll(this.search_packages);
        return list;
    }

    public Set fetch_static_imports(Set set) {
        JVMScope parent_scope = this.outer_scope();
        if (parent_scope != null) {
            parent_scope.fetch_static_imports(set);
        }
        set.addAll(this.staticImports);
        return set;
    }

    @Override
    public Map imports() {
        return this.cached_imports != null ? this.cached_imports : (this.cached_imports = this.fetch_imports(new HashMap(16)));
    }

    @Override
    public List search_packages() {
        return this.cached_packages != null ? this.cached_packages : (this.cached_packages = this.fetch_packages(new ArrayList(0)));
    }

    public JVMScope add_import(String fullname, String shortname) {
        JVMScope jVMScope = this;
        jVMScope.import(fullname, shortname);
        return jVMScope;
    }

    @Override
    public void import(String fullname, String shortname) {
        this.flush();
        if ("*".equals(shortname)) {
            this.search_packages.add(fullname);
        } else {
            this.imports.put(shortname, fullname);
        }
    }

    @Override
    public TypeFuture selfType() {
        block0: {
            if ((this.selfType == null ? this.parent() : null) == null) break block0;
            this.selfType = this.parent().selfType();
        }
        return this.selfType;
    }

    @Override
    public void selfType_set(TypeFuture type) {
        this.selfType = type;
    }

    @Override
    public void staticImport(TypeFuture type) {
        this.flush();
        this.staticImports.add(type);
    }

    public Set staticImports() {
        return this.cached_static_imports != null ? this.cached_static_imports : (this.cached_static_imports = this.fetch_static_imports(new HashSet()));
    }

    public Set flush() {
        this.cached_imports = null;
        this.cached_packages = null;
        this.cached_static_imports = null;
        return this.cached_static_imports;
    }

    @Override
    public void shadow(String name) {
        this.defined_locals.add(name);
        this.shadowed.add(name);
    }

    public JVMScope() {
        this(null);
    }
}

