/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodListener;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.typer.ResolvedType;
import org.objectweb.asm.Opcodes;

public class MetaType
extends BaseType {
    private MirrorType unmeta;

    public MetaType(MirrorType type) {
        super(null, type.name(), type.getAsmType(), type.flags() | Opcodes.ACC_STATIC, type.superclass());
        this.unmeta = type;
    }

    @Override
    public MirrorType unmeta() {
        return this.unmeta;
    }

    @Override
    public boolean isMeta() {
        return true;
    }

    @Override
    public ResolvedType widen(ResolvedType other) {
        return this.unmeta().widen(other);
    }

    @Override
    public void notifyOfIncompatibleChange() {
        this.unmeta().notifyOfIncompatibleChange();
    }

    @Override
    public void onIncompatibleChange(Runnable listener) {
        this.unmeta().onIncompatibleChange(listener);
    }

    @Override
    public void invalidateMethod(String name) {
        this.unmeta().invalidateMethod(name);
    }

    @Override
    public void addMethodListener(String name, MethodListener listener) {
        this.unmeta().addMethodListener(name, listener);
    }

    @Override
    public JVMMethod getDeclaredField(String name) {
        JVMMethod field = this.unmeta().getDeclaredField(name);
        return (field != null ? Opcodes.ACC_STATIC == (((Member)field).flags() & Opcodes.ACC_STATIC) : false) ? field : null;
    }
}

