/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.ResolvedType;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class NullType
extends BaseType
implements javax.lang.model.type.NullType {
    public NullType() {
        super(null, "null", Type.getType("Ljava/lang/Object;"), Opcodes.ACC_PUBLIC, null);
    }

    @Override
    public ResolvedType widen(ResolvedType other) {
        return other.matchesAnything() ? this : other;
    }

    @Override
    public boolean assignableFrom(ResolvedType other) {
        if (other.matchesAnything()) {
            return true;
        }
        return other instanceof JVMType ? !JVMTypeUtils.isPrimitive((JVMType)other) : false;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.NULL;
    }

    @Override
    public Object accept(TypeVisitor v, Object p) {
        return v.visitNull(this, p);
    }

    @Override
    public int hashCode() {
        return TypeKind.NULL.hashCode();
    }

    @Override
    public boolean isSameType(MirrorType other) {
        return other.getKind() == TypeKind.NULL;
    }

    @Override
    public boolean isSupertypeOf(MirrorType other) {
        return this.isSameType(other);
    }
}

