/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.HashMap;
import java.util.Map;
import org.mirah.jvm.mirrors.BooleanType;
import org.mirah.jvm.mirrors.MirrorLoader;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.Number;
import org.mirah.jvm.mirrors.SimpleMirrorLoader;
import org.mirah.jvm.mirrors.VoidType;
import org.mirah.util.Context;
import org.objectweb.asm.Type;

public class PrimitiveLoader
extends SimpleMirrorLoader {
    private Map mirrors;
    private Context context;

    public PrimitiveLoader(Context context, MirrorLoader parent) {
        super(parent);
        this.context = context;
        this.mirrors = new HashMap(16);
        this.defineVoidType();
        this.defineBoolean();
        Number d = this.defineNumber("D", null);
        Number f = this.defineNumber("F", d);
        Number l = this.defineNumber("J", f);
        Number i = this.defineNumber("I", l);
        this.defineNumber("C", i);
        Number s = this.defineNumber("S", i);
        this.defineNumber("B", s);
    }

    public VoidType defineVoidType() {
        VoidType val0 = new VoidType();
        this.mirrors.put(Type.getType("V"), val0);
        return val0;
    }

    public Number defineNumber(String desc, MirrorType supertype) {
        Type type = Type.getType(desc);
        Number val0 = new Number(this.context, type, supertype, this);
        this.mirrors.put(type, val0);
        return val0;
    }

    public BooleanType defineBoolean() {
        Type type = Type.getType("Z");
        BooleanType val0 = new BooleanType(this.context, this);
        this.mirrors.put(type, val0);
        return val0;
    }

    @Override
    public MirrorType findMirror(Type type) {
        MirrorType $or$2 = super.findMirror(type);
        return $or$2 != null ? $or$2 : (MirrorType)this.mirrors.get(type);
    }

    public PrimitiveLoader(Context context) {
        this(context, null);
    }
}

