/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mirah.jvm.mirrors.DeclaredMirrorType;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.generics.Constraints;
import org.mirah.jvm.mirrors.generics.MethodSignatureReader;
import org.mirah.jvm.mirrors.generics.Substitutor;
import org.mirah.jvm.mirrors.generics.TypeParameterInference;
import org.mirah.jvm.mirrors.generics.TypeVariable;
import org.mirah.jvm.types.JVMType;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.GenericTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;

public class GenericMethodLookup {
    private Context context;
    private MirrorTypeSystem types;
    private static Logger log = Logger.getLogger(MethodLookup.class.getName());

    public GenericMethodLookup(Context context) {
        this.context = context;
        this.types = (MirrorTypeSystem)this.context.get(MirrorTypeSystem.class);
    }

    public List processGenerics(MirrorType target, List params, List members) {
        boolean gensym0 = false;
        for (ResolvedType x : params) {
            boolean $or$1 = x == null;
            if (!($or$1 ? $or$1 : x.isError())) continue;
            gensym0 = true;
            break;
        }
        if (gensym0) {
            return members;
        }
        ArrayList<Member> result = new ArrayList<Member>(members.size());
        for (Member member : members) {
            String generic_constructor;
            String string = generic_constructor = ("<init>".equals(member.name()) ? target.unmeta() instanceof DeclaredMirrorType : false) ? ((DeclaredMirrorType)target.unmeta()).signature() : null;
            boolean bl = member.signature() == null ? generic_constructor == null : false;
            if (bl) {
                result.add(member);
                continue;
            }
            try {
                Member generic_method = this.processMethod(member, target, params);
                if (generic_method == null) continue;
                result.add(generic_method);
            }
            catch (Throwable ex$568850999) {
                log.log(Level.WARNING, "Error during generic method processing for " + member, ex$568850999);
                result.add(member);
            }
        }
        return result;
    }

    public Member processMethod(Member method, MirrorType target, List params) {
        TypeParameterInference inference = new TypeParameterInference((Types)this.context.get(Types.class));
        Map initial_vars = this.calculateInitialVars(inference, method, target);
        MethodSignatureReader methodReader = this.readMethodSignature(method, initial_vars);
        Map type_params = this.getTypeParams(target, methodReader.getFormalTypeParameters(), "<init>".equals(method.name()));
        initial_vars.putAll(type_params);
        List generic_params = methodReader.getFormalParameterTypes();
        Map constraint_map = this.collectConstraints(inference, this.findUnsolved(initial_vars), generic_params, params, method.isVararg());
        Map solved_vars = this.solveConstraints(constraint_map, initial_vars);
        this.lockSolutions(solved_vars, type_params.keySet());
        if (this.methodIsApplicable(generic_params, params, solved_vars, method.isVararg())) {
            return this.substituteReturnType(method, methodReader.genericReturnType(), solved_vars);
        }
        return null;
    }

    public MethodSignatureReader readMethodSignature(Member method, Map typevar_futures) {
        HashMap<String, TypeFuture> new_map = new HashMap<String, TypeFuture>();
        for (String k : typevar_futures.keySet()) {
            TypeFuture future = (TypeFuture)typevar_futures.get(k);
            if (future instanceof GenericTypeFuture) {
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved(new TypeVariable(this.context, k, (MirrorType)future.resolve()));
                new_map.put(k, baseTypeFuture);
                continue;
            }
            new_map.put(k, future);
        }
        MethodSignatureReader methodReader = new MethodSignatureReader(this.context, new_map);
        methodReader.readMember(method);
        return methodReader;
    }

    public Map getTypeParams(MirrorType target, Collection type_params, boolean isInit) {
        Map<String, TypeFuture> result = Collections.checkedMap(new HashMap(), String.class, TypeFuture.class);
        if (target instanceof DeclaredMirrorType ? isInit : false) {
            for (TypeFuture x : ((DeclaredMirrorType)target).getTypeVariableMap().values()) {
                TypeVariable tv = (TypeVariable)x.resolve();
                result.put(tv.toString(), new GenericTypeFuture(null, (MirrorType)tv.getUpperBound()));
            }
        }
        for (TypeVariable tv : type_params) {
            result.put(tv.toString(), new GenericTypeFuture(null, (MirrorType)tv.getUpperBound()));
        }
        return result;
    }

    public Set findUnsolved(Map initial_vars) {
        HashSet unsolved = new HashSet();
        for (Object k : initial_vars.keySet()) {
            Object v = initial_vars.get(k);
            if (!(v instanceof GenericTypeFuture)) continue;
            unsolved.add(k);
        }
        return unsolved;
    }

    public Map collectConstraints(TypeParameterInference inference, Collection type_params, List generic_params, List params, boolean isVararg) {
        int arg_count = generic_params.size();
        int required_count = isVararg ? arg_count - 1 : arg_count;
        Map<String, Constraints> constraint_map = Collections.checkedMap(new HashMap(16), String.class, Constraints.class);
        for (Object v : type_params) {
            constraint_map.put((String)v, new Constraints());
        }
        MirrorType vararg_component = null;
        int i = 0;
        Iterator gensym1 = params.iterator();
        Iterator gensym2 = generic_params.iterator();
        while (gensym1.hasNext()) {
            TypeMirror argument = (TypeMirror)gensym1.next();
            TypeMirror param = gensym2.hasNext() ? gensym2.next() : null;
            if (param == null) {
                inference.processArgument(argument, '<', vararg_component, constraint_map);
            } else if (i == required_count) {
                MirrorType vararg = (MirrorType)param;
                if (vararg.isSupertypeOf((MirrorType)argument)) {
                    inference.processArgument(argument, '<', param, constraint_map);
                } else {
                    vararg_component = (MirrorType)vararg.getComponentType();
                    inference.processArgument(argument, '<', vararg_component, constraint_map);
                }
            }
            inference.processArgument(argument, '<', param, constraint_map);
        }
        return constraint_map;
    }

    public Map calculateInitialVars(TypeParameterInference inference, Member method, MirrorType target) {
        HashMap result = new HashMap(16);
        if (target.isMeta()) {
            return result;
        }
        DeclaredMirrorType generic_target = (DeclaredMirrorType)inference.findMatchingSupertype(target, (DeclaredType)((Object)method.declaringClass()));
        if (generic_target == null) {
            return result;
        }
        Map vars = generic_target.getTypeVariableMap();
        for (Object k : vars.keySet()) {
            result.put(k.toString(), vars.get(k));
        }
        return result;
    }

    public ResolvedType newInvocation(JVMType type, Map typevars) {
        DeclaredMirrorType declared;
        Map vars;
        if (type instanceof DeclaredMirrorType && !(vars = (declared = (DeclaredMirrorType)type).getTypeVariableMap()).isEmpty()) {
            ArrayList args = new ArrayList(vars.size());
            for (Object k : vars.keySet()) {
                args.add(typevars.get(k));
            }
            BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
            baseTypeFuture.resolved(type);
            return this.types.parameterize(baseTypeFuture, args).resolve();
        }
        return type;
    }

    public Map solveConstraints(Map constraints, Map solved) {
        Constraints c;
        for (Object tv : constraints.keySet()) {
            c = (Constraints)constraints.get(tv);
            for (MirrorType t : c.getEqual()) {
                if (t.getKind() == TypeKind.TYPEVAR && t.toString().equals(tv.toString())) continue;
                GenericTypeFuture tv_future = (GenericTypeFuture)solved.get(tv);
                GenericTypeFuture t_future = (GenericTypeFuture)solved.get(t);
                if (t_future != null) {
                    tv_future.assign(t_future, null);
                    continue;
                }
                tv_future.resolved(t);
            }
        }
        for (Object tv : constraints.keySet()) {
            c = (Constraints)constraints.get(tv);
            GenericTypeFuture future = (GenericTypeFuture)solved.get(tv);
            for (MirrorType result : c.getSuper()) {
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved(result);
                future.assign(baseTypeFuture, null);
            }
        }
        return solved;
    }

    public void lockSolutions(Map solved, Collection lockable) {
        for (Object k : lockable) {
            GenericTypeFuture future = (GenericTypeFuture)solved.get(k);
            if (!future.isResolved()) continue;
            BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
            baseTypeFuture.resolved(future.resolve());
            solved.put(k, baseTypeFuture);
        }
    }

    public MirrorType substituteTypeVariables(TypeMirror type, Map typevars) {
        Substitutor visitor = new Substitutor(this.context, typevars);
        TypeFuture future = (TypeFuture)visitor.visit(type);
        return (MirrorType)future.resolve();
    }

    public Member substituteReturnType(Member method, TypeMirror returnType, Map typevars) {
        Member member;
        ResolvedType newReturnType;
        ResolvedType resolvedType = newReturnType = "<init>".equals(method.name()) ? this.newInvocation(method.declaringClass(), typevars) : this.substituteTypeVariables(returnType, typevars);
        if (newReturnType == method.genericReturnType()) {
            member = method;
        } else {
            Member newMember = new Member(method.flags(), method.declaringClass(), method.name(), method.argumentTypes(), method.returnType(), method.kind());
            newMember.genericReturnType_set((JVMType)newReturnType);
            member = newMember;
        }
        return member;
    }

    public boolean methodIsApplicable(List params, List args, Map typevars, boolean isVararg) {
        int required_count = isVararg ? params.size() - 1 : -1;
        ResolvedType vararg_component = null;
        int i = 0;
        Iterator gensym0 = args.iterator();
        Iterator gensym1 = params.iterator();
        while (gensym0.hasNext()) {
            MirrorType arg = (MirrorType)gensym0.next();
            TypeMirror param = gensym1.hasNext() ? gensym1.next() : null;
            if (param == null) {
                if (vararg_component.assignableFrom(arg)) continue;
                return false;
            }
            MirrorType substituted = this.substituteTypeVariables(param, typevars);
            if (i == required_count) {
                MirrorType vararg = substituted;
                if ((args.size() == params.size() ? vararg.assignableFrom(arg) : false) || (vararg_component = (MirrorType)vararg.getComponentType()).assignableFrom(arg)) continue;
                return false;
            }
            if (substituted.assignableFrom(arg)) continue;
            return false;
        }
        return true;
    }
}

