/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$1;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$2;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$3;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$4;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$5;
import org.mirah.jvm.mirrors.generics.TypeParameterInference$6;
import org.mirah.jvm.types.JVMTypeUtils;

public class TypeParameterInference {
    private Types types;

    public TypeParameterInference(Types types) {
        this.types = types;
    }

    public void processArgument(TypeMirror argument, char constraint, TypeMirror formalParameter, Map typeParameters) {
        if (TypeKind.NULL == argument.getKind()) {
            return;
        }
        if (constraint == '<') {
            this.processExtendsConstraint(argument, formalParameter, typeParameters);
            return;
        }
        if (constraint == '=') {
            this.processEqualConstraint(argument, formalParameter, typeParameters);
            return;
        }
        if (constraint == '>') {
            this.processSuperConstraint(argument, formalParameter, typeParameters);
            return;
        }
        throw new IllegalArgumentException("Invalid constraint " + constraint);
    }

    public void processExtendsConstraint(TypeMirror argument, TypeMirror formalParameter, Map typeParameters) {
        block1: {
            new TypeParameterInference$1().typeParameters = typeParameters;
            TypeParameterInference$1 typeParameterInference$1 = new TypeParameterInference$1();
            if (argument instanceof MirrorType ? JVMTypeUtils.isPrimitive((MirrorType)argument) : false) {
                argument = (TypeMirror)((Object)((MirrorType)argument).box());
            }
            typeParameterInference$1.tpi = this;
            typeParameterInference$1.visitor = new TypeParameterInference$2(typeParameterInference$1);
            if (formalParameter == null) break block1;
            formalParameter.accept(typeParameterInference$1.visitor, argument);
        }
    }

    public void processEqualConstraint(TypeMirror argument, TypeMirror formalParameter, Map typeParameters) {
        new TypeParameterInference$3().typeParameters = typeParameters;
        TypeParameterInference$3 typeParameterInference$3 = new TypeParameterInference$3();
        typeParameterInference$3.tpi = this;
        typeParameterInference$3.visitor = new TypeParameterInference$4(typeParameterInference$3);
        formalParameter.accept(typeParameterInference$3.visitor, argument);
    }

    public void processSuperConstraint(TypeMirror argument, TypeMirror formalParameter, Map typeParameters) {
        new TypeParameterInference$5().typeParameters = typeParameters;
        TypeParameterInference$5 typeParameterInference$5 = new TypeParameterInference$5();
        typeParameterInference$5.tpi = this;
        typeParameterInference$5.visitor = new TypeParameterInference$6(typeParameterInference$5);
        formalParameter.accept(typeParameterInference$5.visitor, argument);
    }

    public List findExtendsTypeArguments(TypeMirror arg, DeclaredType param) {
        DeclaredType type = this.findMatchingSupertype(arg, param);
        return type != null ? type.getTypeArguments() : Collections.emptyList();
    }

    public List findEqualTypeArguments(TypeMirror arg, DeclaredType param) {
        if (arg.getKind() == TypeKind.DECLARED && this.types.asElement(arg).equals(this.types.asElement(param))) {
            return ((DeclaredType)arg).getTypeArguments();
        }
        return Collections.emptyList();
    }

    public DeclaredType findMatchingSupertype(TypeMirror subtype, DeclaredType supertype) {
        Element super_elem = this.types.asElement(supertype);
        LinkedList<? extends TypeMirror> types = new LinkedList<TypeMirror>();
        types.add(subtype);
        while (types.size() > 0) {
            TypeMirror t = (TypeMirror)types.removeFirst();
            if (t.getKind() == TypeKind.DECLARED && this.types.asElement(t).equals(super_elem)) {
                return (DeclaredType)t;
            }
            types.addAll(this.types.directSupertypes(t));
        }
        return null;
    }

    public DeclaredType[] findMatchingGenericSupertypes(TypeMirror arg, DeclaredType param) {
        DeclaredType argType;
        if (arg.getKind() == TypeKind.DECLARED && !(argType = (DeclaredType)arg).getTypeArguments().isEmpty()) {
            param = this.findMatchingSupertype(param, argType);
            DeclaredType[] result = new DeclaredType[]{argType, param};
            return result;
        }
        return null;
    }

    public WildcardType wildcard(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD ? (WildcardType)type : null;
    }
}

