/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.types;

import org.mirah.jvm.types.JVMType;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class JVMTypeUtils {
    public static boolean isPrimitive(JVMType type) {
        if (type.isError()) {
            return false;
        }
        int sort = type.getAsmType().getSort();
        return sort != Type.OBJECT ? sort != Type.ARRAY : false;
    }

    public static boolean isEnum(JVMType type) {
        return 0 != (type.flags() & Opcodes.ACC_ENUM);
    }

    public static boolean isInterface(JVMType type) {
        return 0 != (type.flags() & Opcodes.ACC_INTERFACE);
    }

    public static boolean isAbstract(JVMType type) {
        return 0 != (type.flags() & Opcodes.ACC_ABSTRACT);
    }

    public static boolean isAnnotation(JVMType type) {
        return 0 != (type.flags() & Opcodes.ACC_ANNOTATION);
    }

    public static boolean isArray(JVMType type) {
        return type.getAsmType().getSort() == Type.ARRAY;
    }
}

