/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import mirah.lang.ast.StreamCodeSource;
import org.mirah.MirahLogFormatter;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.tool.MirahArguments$1;
import org.mirah.tool.MirahArguments$10;
import org.mirah.tool.MirahArguments$11;
import org.mirah.tool.MirahArguments$12;
import org.mirah.tool.MirahArguments$13;
import org.mirah.tool.MirahArguments$14;
import org.mirah.tool.MirahArguments$15;
import org.mirah.tool.MirahArguments$16;
import org.mirah.tool.MirahArguments$2;
import org.mirah.tool.MirahArguments$3;
import org.mirah.tool.MirahArguments$4;
import org.mirah.tool.MirahArguments$5;
import org.mirah.tool.MirahArguments$6;
import org.mirah.tool.MirahArguments$7;
import org.mirah.tool.MirahArguments$8;
import org.mirah.tool.MirahArguments$9;
import org.mirah.util.OptionParser;
import org.mirah.util.SimpleDiagnostics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MirahArguments {
    private boolean silent;
    private HashSet real_loggers;
    private URL[] bootclasspath;
    private URL[] macroclasspath;
    private List code_sources = new ArrayList(0);
    private String vloggers;
    private boolean use_type_debugger = false;
    private boolean logger_color = true;
    private boolean should_exit;
    private URL[] classpath = null;
    private String destination = ".";
    private int max_errors;
    private static String VERSION = "0.1.4.dev";
    private boolean verbose;
    private JvmVersion jvm_version = new JvmVersion();
    private Logger logger;
    private SimpleDiagnostics diagnostics = new SimpleDiagnostics(true);
    private int exit_status;

    public boolean logger_color() {
        return this.logger_color;
    }

    public List code_sources() {
        return this.code_sources;
    }

    public JvmVersion jvm_version() {
        return this.jvm_version;
    }

    public String destination() {
        return this.destination;
    }

    public SimpleDiagnostics diagnostics() {
        return this.diagnostics;
    }

    public String vloggers() {
        return this.vloggers;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public boolean silent() {
        return this.silent;
    }

    public int max_errors() {
        return this.max_errors;
    }

    public boolean use_type_debugger() {
        return this.use_type_debugger;
    }

    public int exit_status() {
        return this.exit_status;
    }

    public void logger_color_set(boolean value) {
        this.logger_color = value;
    }

    public void code_sources_set(List value) {
        this.code_sources = value;
    }

    public void jvm_version_set(JvmVersion value) {
        this.jvm_version = value;
    }

    public void destination_set(String value) {
        this.destination = value;
    }

    public void diagnostics_set(SimpleDiagnostics value) {
        this.diagnostics = value;
    }

    public void vloggers_set(String value) {
        this.vloggers = value;
    }

    public void verbose_set(boolean value) {
        this.verbose = value;
    }

    public void silent_set(boolean value) {
        this.silent = value;
    }

    public void max_errors_set(int value) {
        this.max_errors = value;
    }

    public void use_type_debugger_set(boolean value) {
        this.use_type_debugger = value;
    }

    public void exit_status_set(int value) {
        this.exit_status = value;
    }

    public URL[] classpath_set(String classpath) {
        this.classpath = this.parseClassPath(classpath);
        return this.classpath;
    }

    public URL[] bootclasspath_set(String classpath) {
        this.bootclasspath = this.parseClassPath(classpath);
        return this.bootclasspath;
    }

    public URL[] macroclasspath_set(String classpath) {
        this.macroclasspath = this.parseClassPath(classpath);
        return this.macroclasspath;
    }

    public URL[] real_classpath() {
        if (this.classpath != null) {
        } else {
            this.classpath = this.parseClassPath(this.destination());
        }
        return this.classpath;
    }

    public URL[] real_bootclasspath() {
        return this.bootclasspath;
    }

    public URL[] real_macroclasspath() {
        return this.macroclasspath;
    }

    public boolean exit?() {
        return this.should_exit;
    }

    public boolean isExit() {
        return this.should_exit;
    }

    public int prep_for_exit(int status) {
        this.should_exit = true;
        this.exit_status = status;
        return this.exit_status;
    }

    public void applyArgs(String[] args) {
        MirahArguments$1 mirahArguments$1 = new MirahArguments$1();
        mirahArguments$1.compiler_args = this;
        OptionParser optionParser = mirahArguments$1.parser = new OptionParser("mirahc [flags] <files or -e SCRIPT>");
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("h");
        arrayList.add("help");
        optionParser.addFlag(arrayList, "Print this help message.", new MirahArguments$2(mirahArguments$1));
        OptionParser optionParser2 = mirahArguments$1.parser;
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("e");
        optionParser2.addFlag(arrayList2, "CODE", "Compile an inline script.\n\t(The class will be named DashE)", new MirahArguments$3(mirahArguments$1));
        mirahArguments$1.version = VERSION;
        OptionParser optionParser3 = mirahArguments$1.parser;
        ArrayList<String> arrayList3 = new ArrayList<String>(2);
        arrayList3.add("v");
        arrayList3.add("version");
        optionParser3.addFlag(arrayList3, "Print the version.", new MirahArguments$4(mirahArguments$1));
        OptionParser optionParser4 = mirahArguments$1.parser;
        ArrayList<String> arrayList4 = new ArrayList<String>(2);
        arrayList4.add("V");
        arrayList4.add("verbose");
        optionParser4.addFlag(arrayList4, "Verbose logging.", new MirahArguments$5(mirahArguments$1));
        OptionParser optionParser5 = mirahArguments$1.parser;
        ArrayList<String> arrayList5 = new ArrayList<String>(1);
        arrayList5.add("vmodule");
        optionParser5.addFlag(arrayList5, "logger.name=LEVEL[,...]", "Customized verbose logging. `logger.name` can be a class or package\n" + "\t(e.g. org.mirah.jvm or org.mirah.tool.Mirahc)\n" + "\t`LEVEL` should be one of \n" + "\t(SEVERE, WARNING, INFO, CONFIG, FINE, FINER FINEST)", new MirahArguments$6(mirahArguments$1));
        OptionParser optionParser6 = mirahArguments$1.parser;
        ArrayList<String> arrayList6 = new ArrayList<String>(1);
        arrayList6.add("silent");
        optionParser6.addFlag(arrayList6, "disable all logging. default for run commands.", new MirahArguments$7(mirahArguments$1));
        OptionParser optionParser7 = mirahArguments$1.parser;
        ArrayList<String> arrayList7 = new ArrayList<String>(2);
        arrayList7.add("classpath");
        arrayList7.add("cp");
        optionParser7.addFlag(arrayList7, "CLASSPATH", "A " + File.pathSeparator + " separated list of directories, JAR \n" + "\tarchives, and ZIP archives to search for class files.", new MirahArguments$8(mirahArguments$1));
        OptionParser optionParser8 = mirahArguments$1.parser;
        ArrayList<String> arrayList8 = new ArrayList<String>(1);
        arrayList8.add("c");
        optionParser8.addFlag(arrayList8, "CLASSPATH", "Deprecated: same as cp/classpath", new MirahArguments$9(mirahArguments$1));
        OptionParser optionParser9 = mirahArguments$1.parser;
        ArrayList<String> arrayList9 = new ArrayList<String>(1);
        arrayList9.add("bootclasspath");
        optionParser9.addFlag(arrayList9, "CLASSPATH", "Classpath to search for standard JRE classes.", new MirahArguments$10(mirahArguments$1));
        OptionParser optionParser10 = mirahArguments$1.parser;
        ArrayList<String> arrayList10 = new ArrayList<String>(1);
        arrayList10.add("macroclasspath");
        optionParser10.addFlag(arrayList10, "CLASSPATH", "Classpath to use when compiling macros.", new MirahArguments$11(mirahArguments$1));
        OptionParser optionParser11 = mirahArguments$1.parser;
        ArrayList<String> arrayList11 = new ArrayList<String>(2);
        arrayList11.add("dest");
        arrayList11.add("d");
        optionParser11.addFlag(arrayList11, "DESTINATION", "Directory where class files should be saved.", new MirahArguments$12(mirahArguments$1));
        OptionParser optionParser12 = mirahArguments$1.parser;
        ArrayList<String> arrayList12 = new ArrayList<String>(1);
        arrayList12.add("all-errors");
        optionParser12.addFlag(arrayList12, "Display all compilation errors, even if there are a lot.", new MirahArguments$13(mirahArguments$1));
        OptionParser optionParser13 = mirahArguments$1.parser;
        ArrayList<String> arrayList13 = new ArrayList<String>(1);
        arrayList13.add("jvm");
        optionParser13.addFlag(arrayList13, "VERSION", "Emit JVM bytecode targeting specified JVM version (1.5, 1.6, 1.7)", new MirahArguments$14(mirahArguments$1));
        OptionParser optionParser14 = mirahArguments$1.parser;
        ArrayList<String> arrayList14 = new ArrayList<String>(1);
        arrayList14.add("no-color");
        optionParser14.addFlag(arrayList14, "Don't use color when writing logs", new MirahArguments$15(mirahArguments$1));
        OptionParser optionParser15 = mirahArguments$1.parser;
        ArrayList<String> arrayList15 = new ArrayList<String>(1);
        arrayList15.add("tdb");
        optionParser15.addFlag(arrayList15, "Start the interactive type debugger.", new MirahArguments$16(mirahArguments$1));
        try {
            for (String filename : mirahArguments$1.parser.parse(args)) {
                File f = new File(filename);
                this.addFileOrDirectory(f);
            }
        }
        catch (IllegalArgumentException e$645659302) {
            System.out.println(e$645659302.getMessage());
            this.prep_for_exit(1);
        }
    }

    public void addFileOrDirectory(File f) {
        if (!f.exists()) {
            throw new IllegalArgumentException("No such file " + f.getPath());
        }
        if (f.isDirectory()) {
            int gensym1 = 0;
            File[] gensym0 = f.listFiles();
            if (gensym1 < gensym0.length) {
                do {
                    File c;
                    boolean $or$1;
                    if (!(($or$1 = (c = gensym0[gensym1]).isDirectory()) ? $or$1 : c.getPath().endsWith(".mirah"))) continue;
                    this.addFileOrDirectory(c);
                } while (++gensym1 < gensym0.length);
            }
        } else {
            this.code_sources().add(new StreamCodeSource(f.getPath()));
        }
    }

    public void setup_logging() {
        boolean bl = (this.silent() ? !this.verbose() : false) ? this.vloggers() == null : false;
        if (bl) {
            LogManager.getLogManager().reset();
            return;
        }
        this.logger = new MirahLogFormatter(this.logger_color()).install();
        if (this.verbose()) {
            this.logger.setLevel(Level.FINE);
        }
        this.real_loggers = this.build_loggers();
    }

    public HashSet build_loggers() {
        HashSet<Logger> loggers = new HashSet<Logger>();
        if (this.vloggers() == null) {
            return loggers;
        }
        String[] split = this.vloggers().split(",");
        for (int i = 0; i < split.length; ++i) {
            String[] pieces = split[i].split("=", 2);
            Logger vlogger = Logger.getLogger(pieces[0]);
            Level level = Level.parse(pieces[1]);
            vlogger.setLevel(level);
            loggers.add(vlogger);
        }
        return loggers;
    }

    public URL[] parseClassPath(String classpath) {
        String[] filenames = classpath.split(File.pathSeparator);
        URL[] urls = new URL[filenames.length];
        int i = 0;
        int gensym0 = filenames.length;
        if (i < gensym0) {
            do {
                urls[i] = new File(filenames[i]).toURI().toURL();
            } while (++i < gensym0);
        }
        return urls;
    }
}

