/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.net.URL;
import java.util.logging.Logger;
import mirah.lang.ast.CodeSource;
import mirah.lang.ast.StringCodeSource;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.tool.CompilationFailure;
import org.mirah.tool.MirahArguments;
import org.mirah.tool.MirahCompiler;
import org.mirah.tool.Mirahc;
import org.mirah.util.SimpleDiagnostics;
import org.mirah.util.TooManyErrorsException;

public abstract class MirahTool
implements BytecodeConsumer {
    private DebuggerInterface debugger;
    private MirahCompiler compiler;
    private MirahArguments compiler_args;
    private static Logger log = Logger.getLogger(Mirahc.class.getName());

    public MirahTool() {
        this.reset();
    }

    public MirahArguments reset() {
        this.compiler_args = new MirahArguments();
        return this.compiler_args;
    }

    public void setDiagnostics(SimpleDiagnostics diagnostics) {
        this.compiler_args.diagnostics_set(diagnostics);
    }

    /*
     * WARNING - void declaration
     */
    public int compile(String[] stringArray) {
        int n;
        SimpleDiagnostics diagnostics;
        block5: {
            void args;
            Object var3_2 = null;
            this.compiler_args.applyArgs((String[])args);
            if (!this.compiler_args.exit?()) break block5;
            return this.compiler_args.exit_status();
        }
        try {
            this.compiler_args.setup_logging();
            boolean bl = this.compiler_args.use_type_debugger() ? this.debugger == null : false;
            if (bl) {
                ConsoleDebugger debugger = new ConsoleDebugger();
                debugger.start();
                this.debugger = debugger.debugger();
            }
            diagnostics = this.compiler_args.diagnostics();
            diagnostics.setMaxErrors(this.compiler_args.max_errors());
            this.compiler = new MirahCompiler(diagnostics, this.compiler_args.jvm_version(), this.compiler_args.real_classpath(), this.compiler_args.real_bootclasspath(), this.compiler_args.real_macroclasspath(), this.compiler_args.destination(), this.debugger);
            this.parseAllFiles();
            this.compiler.infer();
            this.compiler.compile(this);
            n = 0;
        }
        catch (TooManyErrorsException tooManyErrorsException) {
            System.out.println("Too many errors.");
            n = 1;
        }
        catch (CompilationFailure compilationFailure) {
            System.out.println(diagnostics.errorCount() + " errors");
            n = 1;
        }
        return n;
    }

    public void setDestination(String dest) {
        this.compiler_args.destination_set(dest);
    }

    public String destination() {
        return this.compiler_args.destination();
    }

    public void setClasspath(String classpath) {
        this.compiler_args.classpath_set(classpath);
    }

    public URL[] classpath() {
        return this.compiler_args.real_classpath();
    }

    public void setBootClasspath(String classpath) {
        this.compiler_args.bootclasspath_set(classpath);
    }

    public void setMacroClasspath(String classpath) {
        this.compiler_args.macroclasspath_set(classpath);
    }

    public void setMaxErrors(int count) {
        this.compiler_args.max_errors_set(count);
    }

    public void setJvmVersion(String version) {
        this.compiler_args.jvm_version_set(new JvmVersion(version));
    }

    public void setDebugger(DebuggerInterface debugger) {
        this.debugger = debugger;
    }

    public void addFakeFile(String name, String code) {
        this.compiler_args.code_sources().add(new StringCodeSource(name, code));
    }

    public Object parseAllFiles() {
        for (CodeSource c : this.compiler_args.code_sources()) {
            this.compiler.parse(c);
        }
        return null;
    }

    public MirahCompiler compiler() {
        return this.compiler;
    }
}

