/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.BindingReference;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.ImplicitNil;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Position;
import mirah.lang.ast.Raise;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.RescueClause;
import mirah.lang.ast.Return;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.ClosureBuilder$1;
import org.mirah.typer.ClosureBuilder$2;
import org.mirah.typer.ClosureBuilder$3;
import org.mirah.typer.ClosureBuilder$4;
import org.mirah.typer.ClosureBuilder$5;
import org.mirah.typer.ClosureBuilder$6;
import org.mirah.typer.ClosureBuilder$7;
import org.mirah.typer.ClosureBuilder$8;
import org.mirah.typer.DescendentFinder;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClosureBuilder {
    private Scoper scoper;
    private TypeSystem types;
    private Typer typer;
    private static Logger log = Logger.getLogger(ClosureBuilder.class.getName());

    public ClosureBuilder(Typer typer) {
        this.typer = typer;
        this.types = typer.type_system();
        this.scoper = typer.scoper();
    }

    public TypeFuture insert_closure(Block block, ResolvedType parent_type) {
        Node new_node = this.prepare_regular_closure(block, parent_type);
        CallSite parent = (CallSite)block.parent();
        this.replace_block_with_closure_in_call(parent, block, new_node);
        return this.infer(new_node);
    }

    public Call prepare(Block block, ResolvedType parent_type) {
        return (Call)this.prepare_regular_closure(block, parent_type);
    }

    public Node prepare_non_local_return_closure(Block block, ResolvedType parent_type) {
        AssignableTypeFuture assignableTypeFuture;
        ClosureBuilder$1 closureBuilder$1 = new ClosureBuilder$1();
        Node enclosing_node = this.find_enclosing_node(block);
        if (enclosing_node instanceof MethodDefinition) {
            TypeFuture methodType = this.infer(enclosing_node);
            assignableTypeFuture = ((MethodFuture)methodType).returnType();
        } else if (enclosing_node instanceof Script) {
            AssignableTypeFuture future = new AssignableTypeFuture(block.position());
            future.assign(this.infer(enclosing_node), block.position());
            assignableTypeFuture = future;
        } else {
            assignableTypeFuture = null;
        }
        AssignableTypeFuture return_type = assignableTypeFuture;
        ClosureDefinition nlr_klass = this.define_nlr_exception(block);
        block = this.convert_returns_to_raises(block, nlr_klass, return_type);
        Node new_node = this.nlr_prepare(block, parent_type, nlr_klass);
        ResolvedType resolved = return_type.resolve();
        if (resolved == null) {
            throw new Exception("Unable to determine method return type before generating closure including non local return");
        }
        NodeList enclosing_body = this.get_body(enclosing_node);
        Node node_in_body = block.findAncestor(new ClosureBuilder$2(closureBuilder$1));
        Rescue new_call = this.wrap_with_rescue(block, nlr_klass, node_in_body, resolved);
        node_in_body.parent().replaceChild(node_in_body, new_call);
        this.finish_nlr_exception(block, nlr_klass, resolved);
        this.insert_into_body(enclosing_body, nlr_klass);
        this.infer(nlr_klass);
        return new_node;
    }

    public Node prepare_regular_closure(Block block, ResolvedType parent_type) {
        Scope parent_scope = this.get_scope(block);
        ClosureDefinition klass = this.build_closure_class(block, parent_type, parent_scope);
        if (this.contains_methods(block)) {
            this.copy_methods(klass, block, parent_scope);
        } else {
            this.build_method(klass, block, parent_type, parent_scope);
        }
        return this.new_closure_call_node(block, klass);
    }

    public void replace_block_with_closure_in_call(CallSite parent, Block block, Node new_node) {
        if (block == parent.block()) {
            parent.block_set(null);
            parent.parameters().add(new_node);
        } else {
            new_node.setParent(null);
            parent.replaceChild(block, new_node);
        }
    }

    public NodeList find_enclosing_body(Block block) {
        Node enclosing_node = this.find_enclosing_node(block);
        return this.get_body(enclosing_node);
    }

    public NodeList get_body(Node node) {
        return node instanceof MethodDefinition ? ((MethodDefinition)node).body() : ((Script)node).body();
    }

    public Node find_enclosing_node(Node block) {
        ClosureBuilder$3 closureBuilder$3 = new ClosureBuilder$3();
        return block.findAncestor(new ClosureBuilder$4(closureBuilder$3));
    }

    public boolean has_non_local_return(Block block) {
        return !this.contains_methods(block) ? this.contains_return(block) : false;
    }

    public ClosureDefinition define_nlr_exception(Block block) {
        String string;
        ClosureBuilder$5 closureBuilder$5 = new ClosureBuilder$5();
        Node class_or_script = block.findAncestor(new ClosureBuilder$6(closureBuilder$5));
        if (class_or_script instanceof ClassDefinition) {
            string = ((ClassDefinition)class_or_script).name().identifier();
        } else {
            System.out.println(class_or_script);
            String $or$3 = class_or_script.position().source().name();
            String source_name = $or$3 != null ? $or$3 : "DashE";
            String id = "";
            String[] gensym0 = new File(source_name).getName().replace(".duby|.mirah", "").split("[_-]");
            int gensym1 = 0;
            if (gensym1 < gensym0.length) {
                do {
                    String word = gensym0[gensym1];
                    id = id + word.substring(0, 1).toUpperCase() + word.substring(1);
                } while (++gensym1 < gensym0.length);
            }
            string = id;
        }
        String outer_name = string;
        String exception_name = this.get_scope(class_or_script).temp(outer_name + "$NLRException");
        ClosureDefinition nlr_klass = this.build_class(block.position(), this.types.getBaseExceptionType().resolve(), exception_name);
        return nlr_klass;
    }

    public ClosureDefinition finish_nlr_exception(Node block, ClosureDefinition nlr_klass, ResolvedType return_value_type) {
        List list;
        List list2;
        Constant value_type_name = this.makeTypeName(block.position(), return_value_type);
        if (this.void_type?(return_value_type)) {
            list2 = Collections.emptyList();
        } else {
            ArrayList arrayList = new ArrayList(1);
            list2 = arrayList;
            arrayList.add(new RequiredArgument(new SimpleString("return_value"), value_type_name));
        }
        List required_constructor_arguments = list2;
        Arguments args = new Arguments(block.position(), required_constructor_arguments, Collections.emptyList(), null, Collections.emptyList(), null);
        if (this.void_type?(return_value_type)) {
            list = Collections.emptyList();
        } else {
            ArrayList arrayList = new ArrayList(1);
            list = arrayList;
            arrayList.add(new FieldAssign(new SimpleString("return_value"), new LocalAccess(new SimpleString("return_value")), null));
        }
        List body = list;
        ConstructorDefinition constructor = new ConstructorDefinition(new SimpleString("initialize"), args, new SimpleString("void"), body, null);
        nlr_klass.body().add(constructor);
        if (!this.void_type?(return_value_type)) {
            SimpleString name = new SimpleString(block.position(), "return_value");
            args = new Arguments(block.position(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
            MethodDefinition method = new MethodDefinition(block.position(), name, args, value_type_name, null, null);
            method.body_set(new NodeList());
            method.body().add(new Return(block.position(), new FieldAccess(new SimpleString("return_value"))));
            nlr_klass.body().add(method);
        }
        return nlr_klass;
    }

    public Node nlr_prepare(Block block, ResolvedType parent_type, Node nlr_klass) {
        Scope parent_scope = this.get_scope(block);
        ClosureDefinition klass = this.build_closure_class(block, parent_type, parent_scope);
        this.build_method(klass, block, parent_type, parent_scope);
        return this.new_closure_call_node(block, klass);
    }

    public ClosureDefinition build_closure_class(Block block, ResolvedType parent_type, Scope parent_scope) {
        ClosureDefinition klass = this.build_class(block.position(), parent_type);
        NodeList enclosing_body = this.find_enclosing_body(block);
        this.build_constructor(enclosing_body, klass, parent_scope);
        this.insert_into_body(enclosing_body, klass);
        return klass;
    }

    public Scope get_scope(Node block) {
        return this.scoper.getScope(block);
    }

    public Rescue wrap_with_rescue(Node block, ClosureDefinition nlr_klass, Node call, ResolvedType nlr_return_type) {
        Node return_value = this.void_type?(nlr_return_type) ? (Node)new ImplicitNil() : (Node)new Call(block.position(), new LocalAccess(new SimpleString("ret_error")), new SimpleString("return_value"), Collections.emptyList(), null);
        Position position = block.position();
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        arrayList.add(call);
        ArrayList<RescueClause> arrayList2 = new ArrayList<RescueClause>(1);
        Position position2 = block.position();
        ArrayList<Constant> arrayList3 = new ArrayList<Constant>(1);
        arrayList3.add(this.makeTypeName(block.position(), nlr_klass));
        SimpleString simpleString = new SimpleString("ret_error");
        ArrayList<Return> arrayList4 = new ArrayList<Return>(1);
        arrayList4.add(new Return(block.position(), return_value));
        arrayList2.add(new RescueClause(position2, arrayList3, simpleString, arrayList4));
        return new Rescue(position, arrayList, arrayList2, null);
    }

    public boolean void_type?(ResolvedType type) {
        return this.types.getVoidType().resolve().equals(type);
    }

    public boolean void_type?(TypeFuture type) {
        return this.types.getVoidType().resolve().equals(type.resolve());
    }

    public Block convert_returns_to_raises(Block block, ClosureDefinition nlr_klass, AssignableTypeFuture nlr_return_type) {
        for (Object _n : this.return_nodes(block)) {
            List list;
            TypeFuture type;
            Return node = (Return)_n;
            TypeFuture typeFuture = type = node.value() != null ? this.infer(node.value()) : this.types.getVoidType();
            boolean bl = this.void_type?(nlr_return_type) ? this.types.getImplicitNilType().resolve() == type.resolve() : false;
            if (bl) {
                list = Collections.emptyList();
            } else {
                ArrayList arrayList = new ArrayList(1);
                list = arrayList;
                arrayList.add(node.value());
            }
            List nlr_constructor_args = list;
            nlr_return_type.assign(type, node.position());
            Position position = node.position();
            ArrayList<Call> arrayList = new ArrayList<Call>(1);
            arrayList.add(new Call(node.position(), this.makeTypeName(node.position(), nlr_klass), new SimpleString("new"), nlr_constructor_args, null));
            Raise _raise = new Raise(position, arrayList);
            node.parent().replaceChild(node, _raise);
        }
        return block;
    }

    public boolean contains_return(Node block) {
        return !this.return_nodes(block).isEmpty();
    }

    public List return_nodes(Node block) {
        ClosureBuilder$7 closureBuilder$7 = new ClosureBuilder$7();
        DescendentFinder finder = new DescendentFinder(false, false, new ClosureBuilder$8(closureBuilder$7));
        finder.scan(block, null);
        return finder.results();
    }

    public Call new_closure_call_node(Block block, Node klass) {
        TypeFuture closure_type = this.infer(klass);
        Constant target = this.makeTypeName(block.position(), closure_type.resolve());
        Position position = block.position();
        SimpleString simpleString = new SimpleString("new");
        ArrayList<BindingReference> arrayList = new ArrayList<BindingReference>(1);
        arrayList.add(new BindingReference());
        return new Call(position, target, simpleString, arrayList, null);
    }

    public ClosureDefinition build_class(Position position, ResolvedType parent_type, String name) {
        List list;
        if (parent_type != null ? parent_type.isInterface() : false) {
            ArrayList arrayList = new ArrayList(1);
            list = arrayList;
            arrayList.add(this.makeTypeName(position, parent_type));
        } else {
            list = Collections.emptyList();
        }
        List interfaces = list;
        boolean $or$4 = parent_type == null;
        Constant superclass = ($or$4 ? $or$4 : parent_type.isInterface()) ? null : this.makeTypeName(position, parent_type);
        Constant constant = null;
        if (name != null) {
            constant = new Constant(position, new SimpleString(position, name));
        }
        return new ClosureDefinition(position, constant, superclass, Collections.emptyList(), interfaces, null);
    }

    public Constant makeTypeName(Position position, ResolvedType type) {
        return new Constant(position, new SimpleString(position, type.name()));
    }

    public Constant makeTypeName(Position position, ClassDefinition type) {
        return new Constant(position, new SimpleString(position, type.name().identifier()));
    }

    public void copy_methods(ClassDefinition klass, Block block, Scope parent_scope) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                MethodDefinition cloned = (MethodDefinition)node.clone();
                this.set_parent_scope(cloned, parent_scope);
                klass.body().add(cloned);
            } while (++i < gensym0);
        }
    }

    public boolean contains_methods(Block block) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                return true;
            } while (++i < gensym0);
        }
        return false;
    }

    public void build_method(ClassDefinition klass, Block block, ResolvedType iface, Scope parent_scope) {
        List methods = this.types.getAbstractMethods(iface);
        if (methods.size() == 0) {
            log.warning("No abstract methods in " + iface);
            return;
        }
        if (methods.size() > 1) {
            throw new UnsupportedOperationException("Multiple abstract methods in " + iface + ": " + methods);
        }
        for (Object _m : methods) {
            Arguments args;
            MethodType mtype = (MethodType)_m;
            SimpleString name = new SimpleString(block.position(), mtype.name());
            Arguments arguments = args = block.arguments() != null ? (Arguments)block.arguments().clone() : new Arguments(block.position(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
            while (args.required().size() < mtype.parameterTypes().size()) {
                RequiredArgument arg = new RequiredArgument(block.position(), new SimpleString("arg" + args.required().size()), null);
                args.required().add(arg);
            }
            Constant return_type = this.makeTypeName(block.position(), mtype.returnType());
            MethodDefinition method = new MethodDefinition(block.position(), name, args, return_type, null, null);
            method.body_set((NodeList)block.body().clone());
            this.set_parent_scope(method, parent_scope);
            klass.body().add(method);
        }
    }

    public void build_constructor(NodeList enclosing_body, ClassDefinition klass, Scope parent_scope) {
        Scope $ptemp$5 = parent_scope;
        ResolvedType $or$6 = $ptemp$5.binding_type();
        if ($or$6 == null) {
            ClosureDefinition binding_klass = this.build_class(klass.position(), null);
            this.insert_into_body(enclosing_body, binding_klass);
            $ptemp$5.binding_type_set(this.infer(binding_klass).resolve());
        }
        Constant binding_type_name = this.makeTypeName(klass.position(), parent_scope.binding_type());
        Position position = klass.position();
        ArrayList<RequiredArgument> arrayList = new ArrayList<RequiredArgument>(1);
        arrayList.add(new RequiredArgument(new SimpleString("binding"), binding_type_name));
        Arguments args = new Arguments(position, arrayList, Collections.emptyList(), null, Collections.emptyList(), null);
        FieldAssign body = new FieldAssign(new SimpleString("binding"), new LocalAccess(new SimpleString("binding")), null);
        SimpleString simpleString = new SimpleString("initialize");
        SimpleString simpleString2 = new SimpleString("void");
        ArrayList<FieldAssign> arrayList2 = new ArrayList<FieldAssign>(1);
        arrayList2.add(body);
        ConstructorDefinition constructor = new ConstructorDefinition(simpleString, args, simpleString2, arrayList2, null);
        klass.body().add(constructor);
    }

    public NodeList insert_into_body(NodeList enclosing_body, ClassDefinition klass) {
        NodeList nodeList = enclosing_body;
        nodeList.insert(0, klass);
        return nodeList;
    }

    public TypeFuture infer(Node node) {
        return this.typer.infer(node);
    }

    public Scope set_parent_scope(MethodDefinition method, Scope parent_scope) {
        Scope scope = this.scoper.addScope(method);
        scope.parent_set(parent_scope);
        return scope;
    }
}

