/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.impl.MirahParser;
import mirah.lang.ast.Node;
import mirah.lang.ast.Position;
import mirah.lang.ast.Script;
import mirah.lang.ast.StreamCodeSource;
import mirah.lang.ast.TypeRef;
import org.mirah.MirahLogFormatter;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.CallFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.ListWrapper;
import org.mirah.typer.simple.SimpleScoper;
import org.mirah.typer.simple.SimpleType;
import org.mirah.typer.simple.TypePrinter;

public class SimpleTypes
implements TypeSystem {
    private Map methods;
    private SimpleType main_type;
    private Map locals;
    private Map array_types;
    private Map meta_types;
    private Map types = new HashMap(16);
    private Map fields;

    public SimpleTypes(String main_type) {
        ArrayList<String> arrayList = new ArrayList<String>(11);
        arrayList.add("Null");
        arrayList.add("Void");
        arrayList.add("Exception");
        arrayList.add("Regex");
        arrayList.add("String");
        arrayList.add("Bool");
        arrayList.add("Int");
        arrayList.add("Char");
        arrayList.add("Float");
        arrayList.add("Hash");
        arrayList.add("mirah.impl.Builtin");
        for (String t : arrayList) {
            this.types.put(t, new SimpleType(t, false, false));
        }
        this.meta_types = new HashMap(16);
        this.array_types = new HashMap(16);
        this.methods = new HashMap(16);
        this.fields = new HashMap(16);
        this.locals = new HashMap(16);
        this.main_type = new SimpleType(main_type, false, false);
        this.types.put(main_type, this.main_type);
    }

    public TypeFuture lookup(String name) {
        return (TypeFuture)this.types.get(name);
    }

    @Override
    public TypeFuture getNullType() {
        return this.lookup("Null");
    }

    @Override
    public TypeFuture getImplicitNilType() {
        return this.getNullType();
    }

    @Override
    public TypeFuture getVoidType() {
        return this.lookup("Void");
    }

    @Override
    public TypeFuture getBaseExceptionType() {
        return this.lookup("Exception");
    }

    @Override
    public TypeFuture getDefaultExceptionType() {
        return this.lookup("Exception");
    }

    @Override
    public TypeFuture getRegexType() {
        return this.lookup("Regex");
    }

    @Override
    public TypeFuture getStringType() {
        return this.lookup("String");
    }

    @Override
    public TypeFuture getBooleanType() {
        return this.lookup("Bool");
    }

    @Override
    public TypeFuture getFixnumType(long value) {
        return this.lookup("Int");
    }

    @Override
    public TypeFuture getCharType(int value) {
        return this.lookup("Char");
    }

    @Override
    public TypeFuture getFloatType(double value) {
        return this.lookup("Float");
    }

    @Override
    public TypeFuture getHashType() {
        return this.lookup("Hash");
    }

    @Override
    public ResolvedType getMetaType(ResolvedType type) {
        boolean $or$1 = type.isMeta();
        if ($or$1 ? $or$1 : type.isError()) {
            return type;
        }
        ResolvedType t = (ResolvedType)this.meta_types.get(type);
        if (t == null) {
            t = new SimpleType(type.name(), true, false);
            this.meta_types.put(type, t);
        }
        return t;
    }

    @Override
    public TypeFuture getMetaType(TypeFuture type) {
        return (TypeFuture)((Object)this.getMetaType((ResolvedType)((Object)type)));
    }

    @Override
    public ResolvedType getArrayType(ResolvedType componentType) {
        ResolvedType t = (ResolvedType)this.array_types.get(componentType);
        if (t == null) {
            t = new SimpleType(componentType.name(), false, true);
            this.array_types.put(componentType, t);
        }
        return t;
    }

    @Override
    public TypeFuture getArrayType(TypeFuture componentType) {
        return (TypeFuture)((Object)this.getArrayType(componentType.resolve()));
    }

    public TypeFuture createType(String name) {
        TypeFuture typeFuture;
        if (name.equals(name.toLowerCase())) {
            ArrayList arrayList = new ArrayList(1);
            ArrayList<String> arrayList2 = new ArrayList<String>(1);
            arrayList2.add("Cannot find class " + name);
            arrayList.add(arrayList2);
            typeFuture = new ErrorType(arrayList);
        } else {
            typeFuture = new SimpleType(name, false, false);
        }
        return typeFuture;
    }

    @Override
    public TypeFuture get(Scope scope, TypeRef typeref) {
        TypeFuture basic_type;
        if (typeref == null) {
            throw new IllegalArgumentException();
        }
        TypeFuture $or$2 = this.lookup(typeref.name());
        TypeFuture typeFuture = basic_type = $or$2 != null ? $or$2 : this.createType(typeref.name());
        if (typeref.isStatic()) {
            return this.getMetaType(basic_type);
        }
        if (typeref.isArray()) {
            return this.getArrayType(basic_type);
        }
        return basic_type;
    }

    @Override
    public TypeFuture getMethodType(CallFuture call) {
        ResolvedType target = call.resolved_target();
        ArrayList argTypes = call.resolved_parameters();
        if (target == null) {
            throw new IllegalArgumentException();
        }
        boolean gensym1 = true;
        for (Object gensym0 : argTypes) {
            if (gensym0 != null) continue;
            gensym1 = false;
            break;
        }
        if (!gensym1) {
            BaseTypeFuture error = new BaseTypeFuture(call.position());
            ArrayList arrayList = new ArrayList(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add("Unresolved args");
            arrayList2.add(call.position());
            arrayList.add(arrayList2);
            error.resolved(new ErrorType(arrayList));
            return error;
        }
        return this.getMethodTypeInternal(target, call.name(), argTypes, call.position());
    }

    @Override
    public MethodFuture getMethodDefType(TypeFuture target, String name, List argTypes, TypeFuture returnType, Position position) {
        MethodFuture result;
        block2: {
            ArrayList<ResolvedType> args = new ArrayList<ResolvedType>(argTypes.size());
            int i = 0;
            int gensym0 = argTypes.size();
            if (i < gensym0) {
                do {
                    ResolvedType resolved = ((TypeFuture)argTypes.get(i)).resolve();
                    args.add(i, resolved);
                } while (++i < gensym0);
            }
            result = this.getMethodTypeInternal(target.resolve(), name, args, position);
            if (returnType == null) break block2;
            result.returnType().declare(returnType, position);
        }
        return result;
    }

    public MethodFuture getMethodTypeInternal(ResolvedType target, String name, List argTypes, Position position) {
        if (argTypes.getClass().getName().equals("org.jruby.RubyArray")) {
            argTypes = new ListWrapper(argTypes);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(target);
        arrayList.add(name);
        arrayList.add(argTypes);
        ArrayList<Object> key = arrayList;
        MethodFuture t = (MethodFuture)this.methods.get(key);
        if (t == null) {
            AssignableTypeFuture assignableTypeFuture = new AssignableTypeFuture(null);
            ArrayList arrayList2 = new ArrayList(1);
            ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
            arrayList3.add("Cannot find method " + target + "." + name + argTypes);
            arrayList3.add(position);
            arrayList2.add(arrayList3);
            assignableTypeFuture.resolved(new ErrorType(arrayList2));
            AssignableTypeFuture return_type = assignableTypeFuture;
            t = new MethodFuture(name, argTypes, return_type, false, position);
            this.methods.put(key, t);
        }
        return t;
    }

    @Override
    public AssignableTypeFuture getFieldType(TypeFuture target, String name, Position position) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(target.resolve());
        arrayList.add(name);
        ArrayList<Object> key = arrayList;
        AssignableTypeFuture t = (AssignableTypeFuture)this.fields.get(key);
        if (t == null) {
            t = new AssignableTypeFuture(position);
            this.fields.put(key, t);
        }
        return t;
    }

    @Override
    public AssignableTypeFuture getLocalType(Scope scope, String name, Position position) {
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(scope);
        arrayList.add(name);
        ArrayList<Object> key = arrayList;
        AssignableTypeFuture t = (AssignableTypeFuture)this.locals.get(key);
        if (t == null) {
            t = new AssignableTypeFuture(position);
            this.locals.put(key, t);
        }
        return t;
    }

    @Override
    public TypeFuture getMainType(Scope scope, Script script) {
        return this.main_type;
    }

    @Override
    public TypeFuture getSuperClass(TypeFuture type) {
        return null;
    }

    @Override
    public TypeFuture defineType(Scope scope, Node node, String name, TypeFuture superclass, List interfaces) {
        TypeFuture type = this.lookup(name);
        if (type == null) {
            type = new SimpleType(name, false, false);
            this.types.put(name, type);
        }
        return type;
    }

    @Override
    public void addDefaultImports(Scope scope) {
    }

    public static void main(String[] ARGV) {
        Logger logger = new MirahLogFormatter(true).install();
        logger.setLevel(Level.ALL);
        MirahParser parser = new MirahParser();
        StreamCodeSource code = new StreamCodeSource("stdin", System.in);
        Node ast = (Node)parser.parse(code);
        SimpleTypes types = new SimpleTypes("foo");
        SimpleScoper scopes = new SimpleScoper();
        Typer typer = new Typer(types, scopes, null, null);
        System.out.println("Original AST:");
        new TypePrinter(typer).scan(ast, null);
        System.out.println("");
        System.out.println("Inferring types...");
        typer.infer(ast, false);
        new TypePrinter(typer).scan(ast, null);
    }
}

